/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.old.OldDateTimePropertyDefinition;
import com.openexchange.tools.versit.old.OldFoldingWriter;
import com.openexchange.tools.versit.old.OldParamDefinition;
import com.openexchange.tools.versit.old.OldPropertyDefinition;
import com.openexchange.tools.versit.old.OldScanner;
import com.openexchange.tools.versit.old.OldShortPropertyDefinition;
import com.openexchange.tools.versit.old.OldXBitEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class OldObjectDefinition
implements VersitDefinition {
    protected static final String[] NoNames = new String[0];
    protected static final OldParamDefinition[] NoParams = new OldParamDefinition[0];
    protected static final OldParamDefinition Encoding = new OldParamDefinition(new String[]{"7BIT", "8BIT", "QUOTED-PRINTABLE", "BASE64"});
    protected static final OldParamDefinition TextParam = new OldParamDefinition(NoNames);
    protected static final OldParamDefinition ValueParam = new OldParamDefinition(new String[]{"INLINE", "CONTENT-ID", "CID", "URL"});
    protected static final String[] DefaultParamNames = new String[]{"ENCODING", "CHARSET", "LANGUAGE", "VALUE"};
    protected static final OldParamDefinition[] DefaultParams = new OldParamDefinition[]{Encoding, TextParam, TextParam, ValueParam};
    protected static final OldPropertyDefinition DefaultProperty = new OldPropertyDefinition(DefaultParamNames, DefaultParams);
    protected static final OldShortPropertyDefinition DateTimeProperty = new OldDateTimePropertyDefinition(DefaultParamNames, DefaultParams);
    protected String Name = null;
    protected HashMap<String, OldPropertyDefinition> Properties = new HashMap();
    protected HashMap<String, OldObjectDefinition> Children = new HashMap();

    public OldObjectDefinition(String[] propertyNames, OldPropertyDefinition[] properties) {
        this(propertyNames, properties, new String[0], new OldObjectDefinition[0]);
    }

    public OldObjectDefinition(String[] propertyNames, OldPropertyDefinition[] properties, String[] childNames, OldObjectDefinition[] children) {
        int i;
        for (i = 0; i < propertyNames.length; ++i) {
            this.Properties.put(propertyNames[i].toUpperCase(), properties[i]);
        }
        for (i = 0; i < childNames.length; ++i) {
            this.Children.put(childNames[i].toUpperCase(), children[i]);
        }
    }

    private OldObjectDefinition(String name, HashMap<String, OldPropertyDefinition> properties, HashMap<String, OldObjectDefinition> children) {
        this.Name = name;
        this.Properties.putAll(properties);
        this.Children.putAll(children);
    }

    private String getType(OldScanner s) throws IOException {
        s.skipWS();
        if (s.peek != 58) {
            return null;
        }
        s.read();
        s.skipWS();
        String type = s.parseName();
        s.skipWS();
        if (s.peek == -2) {
            return type;
        }
        throw new VersitException(s, "Invalid BEGIN type");
    }

    public void write(OldFoldingWriter fw, VersitObject object) throws IOException {
        int i;
        fw.write("BEGIN");
        fw.write(":");
        fw.writeln(object.name.getBytes(fw.charset));
        for (i = 0; i < object.getPropertyCount(); ++i) {
            Property property = object.getProperty(i);
            OldPropertyDefinition propdef = this.Properties.get(property.name);
            if (propdef == null) continue;
            propdef.write(fw, property);
        }
        for (i = 0; i < object.getChildCount(); ++i) {
            VersitObject child = object.getChild(i);
            OldObjectDefinition objdef = this.Children.get(child.name);
            if (objdef == null) continue;
            objdef.write(fw, child);
        }
        fw.write("END");
        fw.write(":");
        fw.writeln(object.name.getBytes(fw.charset));
    }

    @Override
    public VersitDefinition.Reader getReader(InputStream stream, String charset) throws IOException {
        OldScanner s = new OldScanner(stream);
        s.DefaultCharset = charset;
        s.DefaultEncoding = OldXBitEncoding.Default;
        return s;
    }

    @Override
    public VersitObject parse(VersitDefinition.Reader reader) throws IOException {
        VersitObject object = this.parseBegin(reader);
        if (object != null) {
            VersitObject child;
            while ((child = this.parseChild(reader, object)) != null) {
                object.addChild(child);
            }
        }
        return object;
    }

    @Override
    public VersitObject parseBegin(VersitDefinition.Reader reader) throws IOException {
        OldScanner s = (OldScanner)reader;
        VersitObject object = new VersitObject(this.Name);
        while (s.peek != -1) {
            if ("BEGIN".equalsIgnoreCase(s.parseName()) && object.name.equalsIgnoreCase(this.getType(s))) {
                return object;
            }
            while (s.peek != -2 && s.peek != -1) {
                s.read();
            }
            while (s.peek == -2) {
                s.read();
            }
        }
        return null;
    }

    @Override
    public VersitObject parseChild(VersitDefinition.Reader reader, VersitObject object) throws IOException {
        OldScanner s = (OldScanner)reader;
        while (s.peek != -1) {
            while (s.peek == -2) {
                s.read();
            }
            String name = s.parseName().toUpperCase();
            if ("END".equalsIgnoreCase(name) && s.peek != 46 && s.peek != 59) {
                s.unfold = false;
                if (object.name.equalsIgnoreCase(this.getType(s))) {
                    return null;
                }
                throw new VersitException(s, "Invalid end of " + object.name);
            }
            if ("BEGIN".equalsIgnoreCase(name) && s.peek != 46 && s.peek != 59) {
                VersitObject grandchild;
                String type = this.getType(s);
                OldObjectDefinition objdef = this.Children.get(type);
                if (objdef == null) {
                    throw new VersitException(s, "Invalid element: " + type);
                }
                VersitObject child = new VersitObject(type);
                while ((grandchild = objdef.parseChild(s, child)) != null) {
                    child.addChild(grandchild);
                }
                return child;
            }
            s.unfold = true;
            while (s.peek == 46) {
                s.read();
                name = s.parseName();
            }
            OldPropertyDefinition propdef = this.Properties.get(name);
            if (propdef == null) {
                propdef = DefaultProperty;
            }
            Property property = new Property(name);
            propdef.parse(s, property);
            object.addProperty(property);
            s.unfold = false;
            if (s.peek == -1 || s.peek == -2) continue;
            throw new VersitException(s, "Error at the end of property");
        }
        return null;
    }

    @Override
    public VersitDefinition.Writer getWriter(OutputStream stream, String charset) throws IOException {
        return new OldFoldingWriter(stream, charset);
    }

    @Override
    public void write(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        this.writeProperties(writer, object);
        this.writeEnd(writer, object);
    }

    @Override
    public void writeProperties(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        int i;
        OldFoldingWriter fw = (OldFoldingWriter)writer;
        fw.write("BEGIN");
        fw.write(":");
        fw.writeln(object.name.getBytes(fw.charset));
        for (i = 0; i < object.getPropertyCount(); ++i) {
            Property property = object.getProperty(i);
            OldPropertyDefinition propdef = this.Properties.get(property.name);
            if (propdef == null) continue;
            propdef.write(fw, property);
        }
        for (i = 0; i < object.getChildCount(); ++i) {
            VersitObject child = object.getChild(i);
            OldObjectDefinition objdef = this.Children.get(child.name);
            if (objdef == null) continue;
            objdef.write(fw, child);
        }
    }

    @Override
    public void writeEnd(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        OldFoldingWriter fw = (OldFoldingWriter)writer;
        fw.write("END");
        fw.write(":");
        fw.writeln(object.name.getBytes(fw.charset));
    }

    @Override
    public VersitDefinition getChildDef(String name) {
        return this.Children.get(name);
    }

    @Override
    public VersitDefinition copy() {
        return new OldObjectDefinition(this.Name, this.Properties, this.Children);
    }

    public Iterator iterator() {
        return this.Properties.values().iterator();
    }
}

