/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.treeconsistency;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermission;
import com.openexchange.tools.oxfolder.treeconsistency.ToDoPermission;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.SQLException;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckPermissionOnInsert
extends CheckPermission {
    private static final Logger LOG = LoggerFactory.getLogger(CheckPermissionOnInsert.class);

    public CheckPermissionOnInsert(Session session, Connection writeCon, Context ctx) {
        super(session, writeCon, ctx);
    }

    public void checkParentPermissions(int parent, OCLPermission[] perms, long lastModified) throws OXException {
        try {
            TIntObjectHashMap map = new TIntObjectHashMap();
            for (int i = 0; i < perms.length; ++i) {
                OCLPermission assignedPerm = perms[i];
                if (!assignedPerm.isFolderVisible()) continue;
                this.ensureParentVisibility(parent, assignedPerm.getEntity(), assignedPerm.isGroupPermission(), (TIntObjectMap<ToDoPermission>)map);
            }
            if (!map.isEmpty()) {
                TIntObjectIterator it = map.iterator();
                int i = map.size();
                while (i-- > 0) {
                    it.advance();
                    int folderId = it.key();
                    ToDoPermission toDoPermission = (ToDoPermission)it.value();
                    int[] users = toDoPermission.getUsers();
                    for (int j = 0; j < users.length; ++j) {
                        LOG.debug("Auto-Insert system-folder-read permission for user {} to folder {}", (Object)UserStorage.getInstance().getUser(users[j], this.ctx).getDisplayName(), (Object)folderId);
                        this.addSystemFolderReadPermission(folderId, users[j], false);
                    }
                    int[] groups = toDoPermission.getGroups();
                    for (int j = 0; j < groups.length; ++j) {
                        LOG.debug("Auto-Insert system-folder-read permission for group {} to folder {}", (Object)GroupStorage.getInstance().getGroup(groups[j], this.ctx).getDisplayName(), (Object)folderId);
                        this.addSystemFolderReadPermission(folderId, groups[j], true);
                    }
                    OXFolderSQL.updateLastModified(folderId, lastModified, this.ctx.getMailadmin(), this.writeCon, this.ctx);
                    ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
                    try {
                        if (FolderCacheManager.isEnabled()) {
                            FolderCacheManager.getInstance().removeFolderObject(folderId, this.ctx);
                        }
                        this.broadcastEvent(folderId, true, ServerServiceRegistry.getInstance().getService(EventAdmin.class));
                        if (FolderQueryCacheManager.isInitialized()) {
                            FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
                        }
                        if (!CalendarCache.isInitialized()) continue;
                        CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
                    }
                    catch (OXException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private void ensureParentVisibility(int parent, int entity, boolean isGroup, TIntObjectMap<ToDoPermission> map) throws OXException, OXException, SQLException {
        if (parent < 20) {
            return;
        }
        FolderObject parentFolder = this.getFolderFromMaster(parent);
        if (!CheckPermissionOnInsert.containsSystemPermission(parentFolder.getPermissions(), entity)) {
            ToDoPermission todo = (ToDoPermission)map.get(parent);
            if (todo == null) {
                todo = new ToDoPermission(parent);
                map.put(parent, (Object)todo);
            }
            if (isGroup) {
                todo.addGroup(entity);
            } else {
                todo.addUser(entity);
            }
        }
        this.ensureParentVisibility(parentFolder.getParentFolderID(), entity, isGroup, map);
    }

    private void addSystemFolderReadPermission(int folderId, int entity, boolean isGroup) throws OXException, SQLException {
        OXFolderSQL.addSinglePermission(folderId, entity, isGroup, 2, 0, 0, 0, false, 1, this.writeCon, this.ctx);
    }
}

