/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.data.Check;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OXFolderUtility {
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderUtility.class);
    private static final String STR_EMPTY = "";
    private static final int[] NO_OBJECT_PERMISSIONS = new int[]{0, 0, 0};
    private static final int[] SORTED_STD_MODULES = new int[]{1, 2, 3, 4};
    private static final String STR_TYPE_PRIVATE = "'private'";
    private static final String STR_TYPE_PUBLIC = "'public'";
    private static final String STR_SYSTEM = "'system'";
    private static final String STR_UNKNOWN = "'unknown'";
    private static final String STR_MODULE_CALENDAR = "'calendar'";
    private static final String STR_MODULE_TASK = "'task'";
    private static final String STR_MODULE_CONTACT = "'contact'";
    private static final String STR_MODULE_UNBOUND = "'unbound'";
    private static final String STR_MODULE_INFOSTORE = "'infostore'";
    private static final String COLUMN_FNAME = "fname";

    private OXFolderUtility() {
    }

    public static int[] getAccessibleModulesForFolders(int[] accessibleModules) {
        int pos;
        if (null == accessibleModules) {
            return null;
        }
        if (!InfostoreFacades.isInfoStoreAvailable() && (pos = Arrays.binarySearch(accessibleModules, 8)) >= 0) {
            int mlen = accessibleModules.length - 1;
            int[] modules = new int[mlen];
            if (0 == pos) {
                System.arraycopy(accessibleModules, 1, modules, 0, modules.length);
            } else {
                System.arraycopy(accessibleModules, 0, modules, 0, pos);
                int len = mlen - pos;
                if (len > 0) {
                    System.arraycopy(accessibleModules, pos + 1, modules, pos, len);
                }
            }
            return modules;
        }
        return accessibleModules;
    }

    public static void checki18nString(int parentFolderId, String folderName, Locale locale, Context ctx) throws OXException {
        if (2 == parentFolderId) {
            if (FolderObject.getFolderString(6, locale).equalsIgnoreCase(folderName)) {
                String parentFolderName = FolderObject.getFolderString(parentFolderId, locale) + " (" + parentFolderId + ')';
                throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(parentFolderName, ctx.getContextId(), folderName);
            }
            if (!OXFolderProperties.isIgnoreSharedAddressbook() && FolderObject.getFolderString(5, locale).equalsIgnoreCase(folderName)) {
                String parentFolderName = FolderObject.getFolderString(parentFolderId, locale) + " (" + parentFolderId + ')';
                throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(parentFolderName, ctx.getContextId(), folderName);
            }
        }
    }

    public static void checkForDuplicateNonSystemPermissions(FolderObject folder, Context ctx) throws OXException {
        OCLPermission[] permissions = folder.getNonSystemPermissionsAsArray();
        if (permissions.length == 0) {
            return;
        }
        TIntHashSet set = new TIntHashSet(permissions.length);
        set.add(permissions[0].getEntity());
        for (int i = 1; i < permissions.length; ++i) {
            OCLPermission permission = permissions[i];
            int key = permission.getEntity();
            if (set.contains(key)) {
                if (permission.isGroupPermission()) {
                    throw OXFolderExceptionCode.DUPLICATE_GROUP_PERMISSION.create(OXFolderUtility.getGroupName(permission.getEntity(), ctx));
                }
                throw OXFolderExceptionCode.DUPLICATE_USER_PERMISSION.create(OXFolderUtility.getUserName(permission.getEntity(), ctx));
            }
            set.add(key);
        }
    }

    public static void checkSimilarNamedSharedFolder(TIntSet diff, FolderObject[] allSharedFolders, String folderName, Context ctx) throws OXException {
        TIntLinkedList affectedUsers = new TIntLinkedList();
        for (FolderObject f : allSharedFolders) {
            if (null == f) continue;
            List<OCLPermission> l = f.getPermissions();
            for (OCLPermission permission : l) {
                if (permission.isGroupPermission()) {
                    try {
                        int[] members;
                        for (int cur : members = GroupStorage.getInstance().getGroup(permission.getEntity(), ctx).getMember()) {
                            if (!diff.contains(cur) || !f.getFolderName().equals(folderName)) continue;
                            affectedUsers.add(cur);
                        }
                        continue;
                    }
                    catch (OXException e) {
                        LOG.error(STR_EMPTY, (Throwable)e);
                        continue;
                    }
                }
                int cur = permission.getEntity();
                if (!diff.contains(cur) || !f.getFolderName().equals(folderName)) continue;
                affectedUsers.add(cur);
            }
        }
        if (!affectedUsers.isEmpty()) {
            throw OXFolderExceptionCode.SIMILAR_NAMED_SHARED_FOLDER.create(folderName);
        }
    }

    public static void checkFolderStringData(FolderObject checkMe) throws OXException {
        String result;
        if (checkMe.containsFolderName() && (result = Check.containsInvalidChars(checkMe.getFolderName())) != null) {
            throw OXFolderExceptionCode.INVALID_DATA.create(result);
        }
    }

    public static void checkFolderPermissions(FolderObject folderObj, int userId, Context ctx, List<OXException> warnings) throws OXException {
        boolean isPrivate = folderObj.getType() == 1 || folderObj.getType() == 3;
        TIntArrayList adminEntities = new TIntArrayList(isPrivate ? 1 : 4);
        int permissionsSize = folderObj.getPermissions().size();
        Iterator<OCLPermission> iter = folderObj.getPermissions().iterator();
        int creator = folderObj.containsCreatedBy() ? folderObj.getCreatedBy() : userId;
        boolean isDefaultFolder = folderObj.containsDefaultFolder() ? folderObj.isDefaultFolder() : false;
        boolean creatorIsAdmin = false;
        for (int i = 0; i < permissionsSize; ++i) {
            OCLPermission oclPerm = iter.next();
            if (oclPerm.getEntity() < 0) {
                throw OXFolderExceptionCode.INVALID_ENTITY.create(oclPerm.getEntity(), OXFolderUtility.getFolderName(folderObj), ctx.getContextId());
            }
            if (!oclPerm.isFolderAdmin()) continue;
            adminEntities.add(oclPerm.getEntity());
            if (isPrivate && folderObj.getModule() != 5) {
                OXFolderUtility.checkPrivateAdminPerm(adminEntities.size(), creator, oclPerm);
            }
            if (!isDefaultFolder || creatorIsAdmin) continue;
            creatorIsAdmin = oclPerm.getEntity() == creator;
        }
        if (!isPrivate && !adminEntities.contains(creator)) {
            iter = folderObj.getPermissions().iterator();
            boolean found = false;
            for (int i = 0; !found && i < permissionsSize; ++i) {
                OCLPermission oclPerm = iter.next();
                if (oclPerm.getEntity() != creator) continue;
                if (!oclPerm.isFolderAdmin()) {
                    warnings.add(OXFolderExceptionCode.CREATOR_STAYS_ADMIN.create(OXFolderUtility.getUserName(creator, ctx), OXFolderUtility.getFolderName(folderObj.getObjectID(), ctx)));
                }
                oclPerm.setFolderAdmin(true);
                found = true;
            }
            if (!found) {
                OCLPermission oclPerm = new OCLPermission();
                oclPerm.setEntity(creator);
                oclPerm.setGroupPermission(false);
                oclPerm.setFolderAdmin(true);
                oclPerm.setAllPermission(0, 0, 0, 0);
                oclPerm.setSystem(0);
                ArrayList<OCLPermission> nList = new ArrayList<OCLPermission>(folderObj.getPermissions());
                nList.add(oclPerm);
                adminEntities.add(creator);
                folderObj.setPermissions(nList);
            }
        }
        if (adminEntities.isEmpty()) {
            throw OXFolderExceptionCode.NO_FOLDER_ADMIN.create();
        }
        if (isDefaultFolder && !creatorIsAdmin) {
            throw OXFolderExceptionCode.CREATOR_IS_NOT_ADMIN.create(OXFolderUtility.getUserName(creator, ctx), OXFolderUtility.getFolderName(folderObj.getObjectID(), ctx));
        }
    }

    private static void checkPrivateAdminPerm(int adminPermissionCount, int creator, OCLPermission oclPerm) throws OXException {
        if (adminPermissionCount > 1) {
            throw OXFolderExceptionCode.ONLY_ONE_PRIVATE_FOLDER_ADMIN.create();
        }
        if (oclPerm.isGroupPermission()) {
            throw OXFolderExceptionCode.NO_PRIVATE_FOLDER_ADMIN_GROUP.create();
        }
        if (creator != oclPerm.getEntity()) {
            throw OXFolderExceptionCode.ONLY_PRIVATE_FOLDER_OWNER_ADMIN.create();
        }
    }

    public static void checkPermissionsAgainstSessionUserConfig(FolderObject folder, UserPermissionBits permissionBits, Context context) throws OXException {
        List<OCLPermission> permissions = folder.getPermissions();
        if (1 < permissions.size() && !permissionBits.hasFullSharedFolderAccess() && (1 == folder.getType() || 2 == folder.getType() && 8 == folder.getModule())) {
            for (int i = 1; i < permissions.size(); ++i) {
                if (OXFolderUtility.isEmptyPermission(permissions.get(i))) continue;
                throw OXFolderExceptionCode.SHARE_FORBIDDEN.create(OXFolderUtility.getUserName(permissionBits.getUserId(), context), OXFolderUtility.getFolderName(folder, context), context.getContextId());
            }
        }
    }

    private static boolean isEmptyPermission(OCLPermission oclPerm) {
        return !oclPerm.isFolderAdmin() && oclPerm.getFolderPermission() == 0 && oclPerm.getReadPermission() == 0 && oclPerm.getWritePermission() == 0 && oclPerm.getDeletePermission() == 0;
    }

    public static void checkSystemFolderPermissions(int folderId, OCLPermission[] newPerms, User user, Context ctx) throws OXException {
        if (folderId >= 20) {
            return;
        }
        int[] allowedObjectPermissions = OXFolderUtility.maxAllowedObjectPermissions(folderId);
        int allowedFolderPermission = OXFolderUtility.maxAllowedFolderPermission(folderId);
        int admin = ctx.getMailadmin();
        if (6 == folderId) {
            for (OCLPermission newPerm : newPerms) {
                if (newPerm.isGroupPermission()) {
                    String i18nName = FolderObject.getFolderString(folderId, user.getLocale());
                    throw OXFolderExceptionCode.NO_GROUP_PERMISSION.create(null == i18nName ? OXFolderUtility.getFolderName(folderId, ctx) : i18nName, ctx.getContextId());
                }
                OXFolderUtility.checkSystemFolderObjectPermissions(folderId, newPerm, admin, allowedObjectPermissions, allowedFolderPermission, user, ctx);
            }
        } else {
            for (OCLPermission newPerm2 : newPerms) {
                OCLPermission newPerm = newPerm2;
                if (!newPerm.isGroupPermission() && newPerm.getEntity() != admin) {
                    String i18nName = FolderObject.getFolderString(folderId, user.getLocale());
                    throw OXFolderExceptionCode.NO_INDIVIDUAL_PERMISSION.create(null == i18nName ? OXFolderUtility.getFolderName(folderId, ctx) : i18nName, ctx.getContextId());
                }
                OXFolderUtility.checkSystemFolderObjectPermissions(folderId, newPerm, admin, allowedObjectPermissions, allowedFolderPermission, user, ctx);
            }
        }
    }

    private static void checkSystemFolderObjectPermissions(int folderId, OCLPermission toCheck, int admin, int[] allowedObjectPermissions, int maxAllowedFolderPermission, User user, Context ctx) throws OXException {
        block3: {
            block2: {
                if (toCheck.getEntity() != admin ? toCheck.isFolderAdmin() : !toCheck.isFolderAdmin()) break block2;
                if (OXFolderUtility.checkObjectPermissions(toCheck, allowedObjectPermissions) && toCheck.getFolderPermission() <= maxAllowedFolderPermission) break block3;
            }
            String i18nName = FolderObject.getFolderString(folderId, user.getLocale());
            throw OXFolderExceptionCode.FOLDER_VISIBILITY_PERMISSION_ONLY.create(null == i18nName ? OXFolderUtility.getFolderName(folderId, ctx) : i18nName, ctx.getContextId());
        }
    }

    private static boolean checkObjectPermissions(OCLPermission p, int[] allowedObjectPermissions) {
        return p.getReadPermission() == allowedObjectPermissions[0] && p.getWritePermission() == allowedObjectPermissions[1] && p.getDeletePermission() == allowedObjectPermissions[2];
    }

    private static int[] maxAllowedObjectPermissions(int folderId) {
        if (6 == folderId) {
            return new int[]{4, OXFolderProperties.isEnableInternalUsersEdit() ? 2 : 0, 0};
        }
        if (15 == folderId) {
            return NO_OBJECT_PERMISSIONS;
        }
        return NO_OBJECT_PERMISSIONS;
    }

    private static int maxAllowedFolderPermission(int folderId) {
        if (6 == folderId) {
            return 2;
        }
        if (15 == folderId) {
            return 8;
        }
        if (2 == folderId) {
            return 8;
        }
        if (9 == folderId) {
            return 2;
        }
        return 0;
    }

    public static OCLPermission[] getPermissionsWithoutFolderAccess(OCLPermission[] newPerms, OCLPermission[] storagePerms) {
        int i;
        boolean found;
        ArrayList<OCLPermission> removed = new ArrayList<OCLPermission>(4);
        TIntHashSet entities = new TIntHashSet(4);
        for (OCLPermission storagePerm : storagePerms) {
            found = false;
            for (i = 0; i < newPerms.length && !found; ++i) {
                if (newPerms[i].getEntity() != storagePerm.getEntity()) continue;
                found = newPerms[i].getFolderPermission() > 0;
            }
            if (found) continue;
            removed.add(storagePerm);
            entities.add(storagePerm.getEntity());
        }
        for (OCLPermission newPerm : newPerms) {
            found = false;
            for (i = 0; i < storagePerms.length && !found; ++i) {
                if (newPerm.getEntity() != storagePerms[i].getEntity()) continue;
                found = true;
            }
            if (found || newPerm.getFolderPermission() > 0 || entities.contains(newPerm.getEntity())) continue;
            removed.add(newPerm);
        }
        return removed.toArray(new OCLPermission[removed.size()]);
    }

    public static void checkPermissionsAgainstUserConfigs(FolderObject folderObj, Context ctx) throws OXException {
        int size = folderObj.getPermissions().size();
        Iterator<OCLPermission> iter = folderObj.getPermissions().iterator();
        UserConfigurationStorage userConfigStorage = UserConfigurationStorage.getInstance();
        for (int i = 0; i < size; ++i) {
            OCLPermission maxApplicablePerm;
            OCLPermission assignedPerm = iter.next();
            if (assignedPerm.isGroupPermission() || OXFolderUtility.isApplicable(maxApplicablePerm = OXFolderUtility.getMaxApplicablePermission(folderObj, userConfigStorage.getUserConfiguration(assignedPerm.getEntity(), ctx)), assignedPerm)) continue;
            throw OXFolderExceptionCode.UNAPPLICABLE_FOLDER_PERM.create(OXFolderUtility.getUserName(assignedPerm.getEntity(), ctx), OXFolderUtility.getFolderName(folderObj), ctx.getContextId());
        }
    }

    private static OCLPermission getMaxApplicablePermission(FolderObject folderObj, UserConfiguration userConfig) {
        EffectivePermission retval = new EffectivePermission(userConfig.getUserId(), folderObj.getObjectID(), folderObj.getType(userConfig.getUserId()), folderObj.getModule(), folderObj.getCreatedBy(), userConfig);
        retval.setFolderAdmin(true);
        retval.setAllPermission(128, 128, 128, 128);
        return retval;
    }

    private static boolean isApplicable(OCLPermission maxApplicablePerm, OCLPermission assignedPerm) {
        if (!maxApplicablePerm.isFolderAdmin() && assignedPerm.isFolderAdmin()) {
            return false;
        }
        return maxApplicablePerm.getFolderPermission() >= assignedPerm.getFolderPermission() && maxApplicablePerm.getReadPermission() >= assignedPerm.getReadPermission() && maxApplicablePerm.getWritePermission() >= assignedPerm.getWritePermission() && maxApplicablePerm.getDeletePermission() >= assignedPerm.getDeletePermission();
    }

    public static void checkSharedSubfolderOwnerPermission(FolderObject parent, FolderObject folderObj, int userId, Context ctx) throws OXException {
        List<OCLPermission> ocls = folderObj.getPermissions();
        int size = ocls.size();
        boolean pownerFound = false;
        for (int i = 0; i < size; ++i) {
            OCLPermission cur = ocls.get(i);
            if (cur.getEntity() == parent.getCreatedBy()) {
                cur.setFolderAdmin(true);
                cur.setAllPermission(128, 128, 128, 128);
                pownerFound = true;
                continue;
            }
            if (!cur.isFolderAdmin()) continue;
            throw OXFolderExceptionCode.INVALID_SHARED_FOLDER_SUBFOLDER_PERMISSION.create(OXFolderUtility.getUserName(userId, ctx), OXFolderUtility.getFolderName(folderObj), ctx.getContextId(), OXFolderUtility.getFolderName(folderObj), ctx.getContextId(), OXFolderUtility.getFolderName(parent));
        }
        if (!pownerFound) {
            OCLPermission pownerPerm = new OCLPermission();
            pownerPerm.setEntity(parent.getCreatedBy());
            pownerPerm.setFolderAdmin(true);
            pownerPerm.setAllPermission(128, 128, 128, 128);
            ocls.add(pownerPerm);
        }
        folderObj.setPermissionsNoClone(ocls);
    }

    public static boolean checkFolderModuleAgainstParentModule(int parentId, int parentModule, int newFolderModule, int cid) throws OXException {
        if (parentModule == 1 || parentModule == 2 || parentModule == 3) {
            return Arrays.binarySearch(SORTED_STD_MODULES, newFolderModule) >= 0;
        }
        if (parentModule == 5) {
            if (parentId == 1 || parentId == 2) {
                return Arrays.binarySearch(SORTED_STD_MODULES, newFolderModule) >= 0;
            }
            if (parentId == 9) {
                return newFolderModule == 8;
            }
        } else {
            if (parentModule == 8) {
                return newFolderModule == 8;
            }
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(parentModule, cid);
        }
        return true;
    }

    public static boolean checkFolderTypeAgainstParentType(FolderObject parentFolder, int newFolderType) {
        int enforcedType;
        switch (parentFolder.getObjectID()) {
            case 1: {
                enforcedType = 1;
                break;
            }
            case 2: {
                enforcedType = 2;
                break;
            }
            case 9: {
                enforcedType = 2;
                break;
            }
            case 10: {
                enforcedType = 2;
                break;
            }
            case 15: {
                enforcedType = 2;
                break;
            }
            default: {
                enforcedType = parentFolder.getType();
            }
        }
        return newFolderType == enforcedType;
    }

    public static boolean isDescendentFolder(TIntList parentIDList, int possibleDescendant, Connection readCon, Context ctx) throws SQLException, OXException {
        int size = parentIDList.size();
        boolean isDescendant = false;
        for (int i = 0; i < size && !isDescendant; ++i) {
            int current;
            TIntList subfolderIDs = OXFolderSQL.getSubfolderIDs(parentIDList.get(i), readCon, ctx);
            int subsize = subfolderIDs.size();
            for (int j = 0; j < subsize && !isDescendant; isDescendant |= (current = subfolderIDs.get(j)) == possibleDescendant, ++j) {
            }
            if (isDescendant) {
                return true;
            }
            isDescendant = OXFolderUtility.isDescendentFolder(subfolderIDs, possibleDescendant, readCon, ctx);
        }
        return isDescendant;
    }

    public static boolean isRenameOnly(FolderObject updateObject, FolderObject storageObject) {
        int updateModule;
        int updateParent;
        List<OCLPermission> updateList;
        if (!updateObject.containsFolderName()) {
            return false;
        }
        String newName = updateObject.getFolderName();
        if (null == newName || newName.equals(storageObject.getFolderName())) {
            return false;
        }
        if (updateObject.containsPermissions() && null != (updateList = Arrays.asList(updateObject.getNonSystemPermissionsAsArray())) && OXFolderUtility.isDifferent(Arrays.asList(storageObject.getNonSystemPermissionsAsArray()), updateList)) {
            return false;
        }
        if (updateObject.containsParentFolderID() && (updateParent = updateObject.getParentFolderID()) > 0 && storageObject.getParentFolderID() != updateParent) {
            return false;
        }
        return !updateObject.containsModule() || (updateModule = updateObject.getModule()) <= 0 || storageObject.getModule() == updateModule;
    }

    public static boolean isDifferent(List<OCLPermission> storageList, List<OCLPermission> updateList) {
        if (updateList.isEmpty()) {
            return false;
        }
        int ssize = storageList.size();
        for (OCLPermission update : updateList) {
            boolean found = false;
            for (int i = 0; i < ssize && !found; ++i) {
                OCLPermission storage = storageList.get(i);
                if (storage.getEntity() != update.getEntity()) continue;
                found = true;
                if (update.equalsPermission(storage)) continue;
                return true;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    public static TIntSet getShareUsers(List<OCLPermission> storageList, List<OCLPermission> updateList, int user, Context ctx) {
        TIntHashSet retval = new TIntHashSet();
        if (null == storageList) {
            for (OCLPermission update : updateList) {
                OXFolderUtility.addPermissionUsers(update, (TIntSet)retval, ctx);
            }
        } else {
            int ssize = storageList.size();
            for (OCLPermission update : updateList) {
                boolean found = false;
                for (int i = 0; i < ssize && !found; ++i) {
                    OCLPermission storage = storageList.get(i);
                    if (storage.getEntity() != update.getEntity()) continue;
                    found = true;
                    if (update.equalsPermission(storage)) continue;
                    OXFolderUtility.addPermissionUsers(update, (TIntSet)retval, ctx);
                }
                if (found) continue;
                OXFolderUtility.addPermissionUsers(update, (TIntSet)retval, ctx);
            }
        }
        retval.remove(user);
        return retval;
    }

    private static void addPermissionUsers(OCLPermission permission, TIntSet retval, Context ctx) {
        if (permission.isGroupPermission()) {
            try {
                int[] members;
                for (int member : members = GroupStorage.getInstance().getGroup(permission.getEntity(), ctx).getMember()) {
                    retval.add(member);
                }
            }
            catch (OXException e) {
                LOG.error(STR_EMPTY, (Throwable)e);
            }
        } else {
            retval.add(permission.getEntity());
        }
    }

    public static String getFolderName(FolderObject folder, Context context) {
        String folderName = folder.getFolderName();
        if (null == folderName) {
            return OXFolderUtility.getFolderName(folder.getObjectID(), context);
        }
        return folderName + " (" + folder.getObjectID() + ')';
    }

    public static String getFolderName(FolderObject fo) {
        String folderName = fo.getFolderName();
        if (null == folderName) {
            return Integer.toString(fo.getObjectID());
        }
        return folderName + " (" + fo.getObjectID() + ')';
    }

    public static String getFolderName(int folderId, Context ctx) {
        try {
            return new OXFolderAccess(ctx).getFolderName(folderId) + " (" + folderId + ')';
        }
        catch (OXException e) {
            return String.valueOf(folderId);
        }
    }

    public static String getUserName(Session session, User u) {
        if (session == null) {
            return STR_EMPTY;
        }
        if (u.getDisplayName() == null) {
            return u.getGivenName() + ' ' + u.getSurname() + " (" + u.getId() + ')';
        }
        return u.getDisplayName() + " (" + u.getId() + ')';
    }

    public static String getUserName(int userId, Context ctx) {
        User u;
        try {
            u = UserStorage.getInstance().getUser(userId, ctx);
        }
        catch (OXException e) {
            return String.valueOf(userId);
        }
        if (u == null) {
            return String.valueOf(userId);
        }
        if (u.getDisplayName() == null) {
            return u.getGivenName() + ' ' + u.getSurname() + " (" + userId + ')';
        }
        return u.getDisplayName() + " (" + userId + ')';
    }

    public static String getUserName(ServerSession session) {
        User u = session.getUser();
        if (u.getDisplayName() == null) {
            return u.getGivenName() + ' ' + u.getSurname() + " (" + u.getId() + ')';
        }
        return u.getDisplayName() + " (" + u.getId() + ')';
    }

    public static String getGroupName(int groupId, Context ctx) {
        Group g;
        try {
            g = GroupStorage.getInstance().getGroup(groupId, ctx);
        }
        catch (OXException e) {
            return String.valueOf(groupId);
        }
        if (g == null) {
            return String.valueOf(groupId);
        }
        if (g.getDisplayName() == null) {
            return g.getSimpleName() + " (" + groupId + ')';
        }
        return g.getDisplayName() + " (" + groupId + ')';
    }

    public static String folderType2String(int type) {
        switch (type) {
            case 1: {
                return STR_TYPE_PRIVATE;
            }
            case 2: {
                return STR_TYPE_PUBLIC;
            }
            case 5: {
                return STR_SYSTEM;
            }
        }
        return STR_UNKNOWN;
    }

    public static String folderModule2String(int module) {
        switch (module) {
            case 2: {
                return STR_MODULE_CALENDAR;
            }
            case 1: {
                return STR_MODULE_TASK;
            }
            case 3: {
                return STR_MODULE_CONTACT;
            }
            case 4: {
                return STR_MODULE_UNBOUND;
            }
            case 5: {
                return STR_SYSTEM;
            }
            case 8: {
                return STR_MODULE_INFOSTORE;
            }
        }
        return STR_UNKNOWN;
    }

    public static String column2Field(String column) {
        if (null == column) {
            return null;
        }
        if (COLUMN_FNAME.equalsIgnoreCase(column)) {
            return "Folder name";
        }
        return null;
    }
}

