/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.scheduler;

import com.openexchange.tools.images.scheduler.SchedulerUncaughtExceptionhandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class SchedulerThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger();
    private final String namePrefix;

    SchedulerThreadFactory() {
        this.namePrefix = "ImageScheduler-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, SchedulerThreadFactory.getThreadName(this.threadNumber.incrementAndGet(), this.namePrefix));
        t.setUncaughtExceptionHandler(SchedulerUncaughtExceptionhandler.getInstance());
        return t;
    }

    private static String getThreadName(int threadNumber, String namePrefix) {
        StringBuilder retval = new StringBuilder(namePrefix.length() + 7);
        retval.append(namePrefix);
        for (int i = threadNumber; i < 1000000; i *= 10) {
            retval.append('0');
        }
        retval.append(threadNumber);
        return retval.toString();
    }
}

