/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.external;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.file.external.QuotaFileStorageExceptionCodes;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QuotaFileStorages {
    private static final ConcurrentMap<String, Boolean> v780Schemas = new ConcurrentHashMap<String, Boolean>();

    private QuotaFileStorages() {
    }

    public static boolean hasUserColumn(Connection connection, int contextID) throws OXException {
        try {
            String schemaName = connection.getCatalog();
            if (null == schemaName && null == (schemaName = ServerServiceRegistry.getServize(DatabaseService.class).getSchemaName(contextID))) {
                throw LdapExceptionCode.UNEXPECTED_ERROR.create("No schema name for connection");
            }
            return QuotaFileStorages.hasUserColumn(connection, schemaName);
        }
        catch (SQLException e) {
            throw QuotaFileStorageExceptionCodes.SQLSTATEMENTERROR.create(e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasUserColumn(Connection connection, String schemaName) throws OXException {
        try {
            Boolean value;
            block4: {
                value = (Boolean)v780Schemas.get(schemaName);
                if (null != value) break block4;
                ResultSet result = null;
                try {
                    result = connection.getMetaData().getColumns(null, schemaName, "user", "filestore_usage");
                    value = result.next();
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result);
                v780Schemas.putIfAbsent(schemaName, value);
            }
            return value;
        }
        catch (SQLException e) {
            throw QuotaFileStorageExceptionCodes.SQLSTATEMENTERROR.create(e, new Object[0]);
        }
    }
}

