/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.exceptions;

import com.openexchange.java.Strings;
import com.openexchange.java.util.Pair;
import com.openexchange.log.LogProperties;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionUtils.class);
    private static final String MARKER = " ---=== /!\\ ===--- ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            Map taskProperties = LogProperties.getPropertyMap();
            if (null == taskProperties) {
                LOG.error("{}Thread death{}", new Object[]{MARKER, MARKER, t});
            } else {
                StringBuilder logBuilder = new StringBuilder(512);
                TreeMap<String, String> sorted = new TreeMap<String, String>();
                for (Map.Entry entry : taskProperties.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (null == value) continue;
                    sorted.put(propertyName, value);
                }
                for (Map.Entry entry : sorted.entrySet()) {
                    logBuilder.append(Strings.getLineSeparator()).append((String)entry.getKey()).append('=').append((String)entry.getValue());
                }
                logBuilder.deleteCharAt(0);
                logBuilder.append(Strings.getLineSeparator()).append(Strings.getLineSeparator());
                logBuilder.append(MARKER);
                logBuilder.append("Thread death");
                logBuilder.append(MARKER);
                LOG.error(logBuilder.toString(), t);
            }
            throw (ThreadDeath)t;
        }
        if (t instanceof OutOfMemoryError) {
            block24: {
                String message = t.getMessage();
                if ("unable to create new native thread".equalsIgnoreCase(message)) {
                    if (!Boolean.TRUE.equals(System.getProperties().get("__thread_dump_created"))) {
                        System.getProperties().put("__thread_dump_created", Boolean.TRUE);
                        boolean error = true;
                        StringBuilder sb = new StringBuilder(2048);
                        try {
                            Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
                            String ls = Strings.getLineSeparator();
                            LOG.info("{}Threads: {}", (Object)ls, (Object)threads.size());
                            for (Map.Entry<Thread, StackTraceElement[]> mapEntry : threads.entrySet()) {
                                Thread thread = mapEntry.getKey();
                                sb.setLength(0);
                                sb.append("        Thread: ").append(thread).append(" java.lang.Thread.State: ").append(thread.getState().name()).append(ls);
                                for (StackTraceElement elem : mapEntry.getValue()) {
                                    sb.append(elem).append(ls);
                                }
                                LOG.info(sb.toString());
                            }
                            sb = null;
                            LOG.info("{}    Thread dump finished{}", (Object)ls, (Object)ls);
                            error = false;
                        }
                        finally {
                            if (error) {
                                System.getProperties().remove("__thread_dump_created");
                            }
                        }
                        LOG.info(sb.toString());
                    }
                } else if ("Java heap space".equalsIgnoreCase(message)) {
                    try {
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        Pair<Boolean, String> heapDumpArgs = ExceptionUtils.checkHeapDumpArguments();
                        if (((Boolean)heapDumpArgs.getFirst()).booleanValue() || Boolean.TRUE.equals(System.getProperties().get("__heap_dump_created"))) break block24;
                        System.getProperties().put("__heap_dump_created", Boolean.TRUE);
                        boolean error = true;
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh:mm:ss", Locale.US);
                            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            String path = null == heapDumpArgs.getSecond() ? "/tmp" : (String)heapDumpArgs.getSecond();
                            String fn = path + "/" + dateFormat.format(new Date()) + "-heap.hprof";
                            String mbeanName = "com.sun.management:type=HotSpotDiagnostic";
                            server.invoke(new ObjectName(mbeanName), "dumpHeap", new Object[]{fn, Boolean.TRUE}, new String[]{String.class.getCanonicalName(), "boolean"});
                            LOG.info("{}    Heap snapshot dumped to file {}{}", new Object[]{Strings.getLineSeparator(), fn, Strings.getLineSeparator()});
                            error = false;
                        }
                        finally {
                            if (error) {
                                System.getProperties().remove("__heap_dump_created");
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ExceptionUtils.logVirtualMachineError(t);
            throw (OutOfMemoryError)t;
        }
        if (t instanceof VirtualMachineError) {
            ExceptionUtils.logVirtualMachineError(t);
            throw (VirtualMachineError)t;
        }
    }

    private static void logVirtualMachineError(Throwable t) {
        Map taskProperties = LogProperties.getPropertyMap();
        if (null == taskProperties) {
            LOG.error("{}The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.{}", new Object[]{MARKER, MARKER, t});
        } else {
            StringBuilder logBuilder = new StringBuilder(512);
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            for (Map.Entry entry : taskProperties.entrySet()) {
                String propertyName = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (null == value) continue;
                sorted.put(propertyName, value);
            }
            for (Map.Entry entry : sorted.entrySet()) {
                logBuilder.append(Strings.getLineSeparator()).append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            logBuilder.deleteCharAt(0);
            logBuilder.append(Strings.getLineSeparator()).append(Strings.getLineSeparator());
            logBuilder.append(MARKER);
            logBuilder.append("The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.");
            logBuilder.append(MARKER);
            LOG.error(logBuilder.toString(), t);
        }
    }

    private static Pair<Boolean, String> checkHeapDumpArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        boolean heapDumpOnOOm = false;
        String path = null;
        for (String argument : arguments) {
            File file;
            if ("-XX:+HeapDumpOnOutOfMemoryError".equals(argument)) {
                heapDumpOnOOm = true;
                continue;
            }
            if (!argument.startsWith("-XX:HeapDumpPath=") || (file = new File(path = argument.substring(17).trim())).exists() && file.canWrite()) continue;
            path = null;
        }
        return new Pair((Object)heapDumpOnOOm, path);
    }
}

