/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import com.openexchange.java.util.UUIDs;
import com.openexchange.session.PutIfAbsent;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class SessionObject
implements PutIfAbsent {
    private final String sessionid;
    private String username;
    private String userlogin;
    private String loginName;
    private String password;
    private String language;
    private String localip;
    private String host;
    private long lifetime;
    private Date timestamp;
    private Date creationtime;
    private String secret;
    private String randomToken;
    private int contextId;
    private String login;
    private String authId;
    private String hash;
    private String client;
    private final ConcurrentMap<String, Object> parameters;

    public SessionObject(String sessionId) {
        this.sessionid = sessionId;
        this.parameters = new ConcurrentHashMap<String, Object>();
        this.parameters.put(PARAM_LOCK, new ReentrantLock());
        this.parameters.put(PARAM_COUNTER, new AtomicInteger());
        this.parameters.put(PARAM_ALTERNATIVE_ID, UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setUserlogin(String userlogin) {
        this.userlogin = userlogin;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLocalIp(String localip) {
        this.localip = localip;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = (Date)timestamp.clone();
    }

    public void setCreationtime(Date creationtime) {
        this.creationtime = (Date)creationtime.clone();
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    public String getSessionID() {
        return this.sessionid;
    }

    public int getUserId() {
        if (this.username == null) {
            return 0;
        }
        return Integer.parseInt(this.username);
    }

    public String getUsername() {
        return this.username;
    }

    public String getUserlogin() {
        return this.userlogin;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLocalIp() {
        return this.localip;
    }

    public String getHost() {
        return this.host;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getCreationtime() {
        return this.creationtime;
    }

    public int getContextId() {
        return this.contextId;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setRandomToken(String randomToken) {
        this.randomToken = randomToken;
    }

    public String getRandomToken() {
        return this.randomToken;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean containsParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, Object value) {
        if (PARAM_LOCK.equals(name)) {
            return;
        }
        if (null == value) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    public Object setParameterIfAbsent(String name, Object value) {
        if (PARAM_LOCK.equals(name)) {
            return this.parameters.get(PARAM_LOCK);
        }
        return this.parameters.putIfAbsent(name, value);
    }

    public void removeRandomToken() {
        this.randomToken = null;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getAuthId() {
        return this.authId;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public boolean isTransient() {
        return false;
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }
}

