/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.jslob.DefaultJSlob;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.Tools;
import com.openexchange.mailaccount.TransportAuth;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.actions.ValidateAction;
import com.openexchange.mailaccount.json.fields.MailAccountFields;
import com.openexchange.mailaccount.json.parser.MailAccountParser;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="new", description="Create a new mail account", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="A JSON object describing the new account to create. See mail account data.", responseDescription="A JSON object representing the inserted mail account. See mail account data.")
public final class NewAction
extends AbstractMailAccountAction
implements MailAccountFields {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewAction.class);
    public static final String ACTION = "new";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jData) throws OXException, JSONException {
        JSONObject jsonAccount;
        JSONObject jBody;
        int id;
        if (!session.getUserPermissionBits().isMultipleMailAccounts()) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
        }
        MailAccountDescription accountDescription = new MailAccountDescription();
        LinkedList<OXException> warnings = new LinkedList<OXException>();
        Set<Attribute> availableAttributes = MailAccountParser.getInstance().parse(accountDescription, jData.toObject(), warnings);
        if (!availableAttributes.contains((Object)Attribute.TRANSPORT_AUTH_LITERAL)) {
            accountDescription.setTransportAuth(TransportAuth.MAIL);
            availableAttributes.add(Attribute.TRANSPORT_AUTH_LITERAL);
        }
        if (TransportAuth.MAIL.equals((Object)accountDescription.getTransportAuth()) || TransportAuth.NONE.equals((Object)accountDescription.getTransportAuth())) {
            availableAttributes.remove((Object)Attribute.TRANSPORT_LOGIN_LITERAL);
            availableAttributes.remove((Object)Attribute.TRANSPORT_PASSWORD_LITERAL);
            accountDescription.setTransportLogin(null);
            accountDescription.setTransportPassword(null);
        }
        NewAction.checkNeededFields(accountDescription);
        if (NewAction.isUnifiedINBOXAccount(accountDescription.getMailProtocol())) {
            throw MailAccountExceptionCodes.UNIFIED_INBOX_ACCOUNT_CREATION_FAILED.create(accountDescription.getId());
        }
        String name = accountDescription.getName();
        if (NewAction.isEmpty(name) || "null".equalsIgnoreCase(name)) {
            accountDescription.setName(accountDescription.getPrimaryAddress());
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        boolean pop3 = Strings.toLowerCase((CharSequence)accountDescription.getMailProtocol()).startsWith("pop3");
        if (!pop3) {
            session.setParameter("mail-account.validate.type", "create");
            try {
                if (!ValidateAction.actionValidateBoolean(accountDescription, session, false, warnings).booleanValue()) {
                    OXException warning = MimeMailExceptionCode.CONNECT_ERROR.create(accountDescription.getMailServer(), accountDescription.getLogin());
                    warning.setCategory(Category.CATEGORY_WARNING);
                    warnings.add(0, warning);
                }
            }
            finally {
                session.setParameter("mail-account.validate.type", null);
            }
        }
        if (!pop3) {
            MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
            try {
                mailAccess = NewAction.getMailAccess(accountDescription, session, warnings);
                mailAccess.connect(false);
                char separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
                mailAccess.close(false);
                mailAccess = null;
                Tools.checkNames(accountDescription, availableAttributes, Character.valueOf(separator));
            }
            finally {
                if (null != mailAccess) {
                    mailAccess.close(false);
                }
            }
        }
        int cid = session.getContextId();
        MailAccount newAccount = null;
        Connection wcon = Database.get(cid, true);
        boolean rollback = false;
        try {
            Databases.startTransaction((Connection)wcon);
            rollback = true;
            id = storageService.insertMailAccount(accountDescription, session.getUserId(), session.getContext(), session, wcon);
            newAccount = storageService.getMailAccount(id, session.getUserId(), cid, wcon);
            if (null == newAccount) {
                throw MailAccountExceptionCodes.NOT_FOUND.create(id, session.getUserId(), session.getContextId());
            }
            newAccount = NewAction.checkFullNames(newAccount, storageService, session, wcon);
            wcon.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(wcon);
            }
            DBUtils.autocommit(wcon);
            Database.back(cid, true, wcon);
        }
        boolean reload = false;
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            mailAccess = MailAccess.getInstance(session, id);
            mailAccess.connect(true);
            reload = true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to live-connect against mail server {} on port {}. Aborting to check default folders consistency.", new Object[]{accountDescription.getMailServer(), accountDescription.getMailPort(), e});
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close();
            }
        }
        if (reload) {
            Connection wcon2 = Database.get(cid, true);
            try {
                newAccount = storageService.getMailAccount(id, session.getUserId(), session.getContextId(), wcon2);
            }
            finally {
                Database.backAfterReading(cid, wcon2);
            }
        }
        if ((jBody = jData.toObject()).hasAndNotNull("meta")) {
            JSONObject jMeta = jBody.optJSONObject("meta");
            NewAction.getStorage().store(new JSlobId("com.openexchange.mailaccount", Integer.toString(id), session.getUserId(), session.getContextId()), (JSlob)new DefaultJSlob(jMeta));
        }
        if (null == newAccount) {
            MailAccount loadedMailAccount = storageService.getMailAccount(id, session.getUserId(), session.getContextId());
            if (null == loadedMailAccount) {
                throw MailAccountExceptionCodes.NOT_FOUND.create(id, session.getUserId(), session.getContextId());
            }
            jsonAccount = MailAccountWriter.write(NewAction.checkFullNames(loadedMailAccount, storageService, session));
        } else {
            jsonAccount = MailAccountWriter.write(newAccount);
        }
        return new AJAXRequestResult(jsonAccount).addWarnings(warnings);
    }
}

