/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final DateFormat DATEFORMAT_RFC822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final DateFormat DATEFORMAT_RFC822_RETRY = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final Pattern PATTERN_RFC822_FIX = Pattern.compile(",(?= 20[0-9][0-9])");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDateRFC822(String string) {
        String s = PATTERN_RFC822_FIX.matcher(string).replaceFirst("");
        try {
            DateFormat dateFormat = DATEFORMAT_RFC822;
            synchronized (dateFormat) {
                return DATEFORMAT_RFC822.parse(s);
            }
        }
        catch (ParseException e) {
            try {
                DateFormat dateFormat = DATEFORMAT_RFC822_RETRY;
                synchronized (dateFormat) {
                    return DATEFORMAT_RFC822_RETRY.parse(s);
                }
            }
            catch (ParseException e1) {
                LOG.trace("", (Throwable)e1);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public static String toStringRFC822(Date d) {
        return DateUtils.toStringRFC822(d, TimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringRFC822(Date d, TimeZone tz) {
        DateFormat dateFormat = DATEFORMAT_RFC822;
        synchronized (dateFormat) {
            DATEFORMAT_RFC822.setTimeZone(tz);
            return DATEFORMAT_RFC822.format(d);
        }
    }

    private DateUtils() {
    }
}

