/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.FileBackedMimeMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.sun.mail.util.MessageRemovedIOException;
import com.sun.mail.util.ReadableMime;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public final class MimeStructureFixer {
    private static final MimeStructureFixer INSTANCE = new MimeStructureFixer();
    private static final String CONTENT_TRANSFER_ENC = MessageHeaders.HDR_CONTENT_TRANSFER_ENC;
    private static final String MIME_VERSION = MessageHeaders.HDR_MIME_VERSION;
    private static final String CONTENT_DISPOSITION = MessageHeaders.HDR_CONTENT_DISPOSITION;
    private static final String CONTENT_TYPE = MessageHeaders.HDR_CONTENT_TYPE;
    private static final String MESSAGE_ID = MessageHeaders.HDR_MESSAGE_ID;
    private static final Pattern PATTERN_BODY_START = Pattern.compile("<body[^>]*?>", 2);
    private static final Pattern PATTERN_BODY_END = Pattern.compile("</body>", 2);
    private static final Set<String> EXCLUDE_BOUNDARY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boundary")));

    public static MimeStructureFixer getInstance() {
        return INSTANCE;
    }

    private MimeStructureFixer() {
    }

    public boolean isApplicableFor(MailMessage message) {
        boolean noAppleMailer;
        if (null == message) {
            return false;
        }
        ContentType contentType = message.getContentType();
        if (!contentType.startsWith("multipart/")) {
            return false;
        }
        if (contentType.startsWith("multipart/signed")) {
            return false;
        }
        String mailer = message.getHeader(MessageHeaders.HDR_X_MAILER, null);
        if (null == mailer || (noAppleMailer = MimeStructureFixer.toLowerCase(mailer).indexOf("apple") < 0)) {
            return false;
        }
        String boundary = contentType.getParameter("boundary");
        return !noAppleMailer || null != boundary && MimeStructureFixer.toLowerCase(boundary).indexOf("apple") >= 0;
    }

    public MailMessage process(MailMessage message) throws OXException {
        if (!this.isApplicableFor(message)) {
            return message;
        }
        ThresholdFileHolder sink = null;
        boolean closeSink = true;
        try {
            sink = new ThresholdFileHolder();
            message.writeTo(sink.asOutputStream());
            File tempFile = sink.getTempFile();
            FileBackedMimeMessage mimeMessage = null == tempFile ? new MimeMessage(MimeDefaultSession.getDefaultSession(), sink.getStream()) : new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), tempFile);
            MimeMessage processed = this.process0(mimeMessage, message.getContentType());
            MailMessage processedMessage = MimeMessageConverter.convertMessage(processed, false);
            processedMessage.setMailId(message.getMailId());
            if (message.containsReceivedDate()) {
                processedMessage.setReceivedDate(message.getReceivedDate());
            }
            if (!processedMessage.containsSize() && message.containsSize()) {
                processedMessage.setSize(message.getSize());
            }
            if (message.containsAccountId()) {
                processedMessage.setAccountId(message.getAccountId());
            }
            if (message.containsFolder()) {
                processedMessage.setFolder(message.getFolder());
            }
            if (message.containsFlags()) {
                processedMessage.setFlags(message.getFlags());
            }
            if (message.containsColorLabel()) {
                processedMessage.setColorLabel(message.getColorLabel());
            }
            if (message.containsUserFlags()) {
                processedMessage.addUserFlags(message.getUserFlags());
            }
            closeSink = false;
            MailMessage mailMessage = processedMessage;
            return mailMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            if (closeSink && null != sink) {
                sink.close();
            }
        }
    }

    public MimeMessage process(MimeMessage mimeMessage) throws OXException {
        if (null == mimeMessage) {
            return mimeMessage;
        }
        ThresholdFileHolder sink = null;
        boolean closeSink = true;
        try {
            Object mime;
            boolean noAppleMailer;
            ContentType contentType = this.getContentType((Part)mimeMessage);
            if (!contentType.startsWith("multipart/")) {
                MimeMessage mimeMessage2 = mimeMessage;
                return mimeMessage2;
            }
            String mailer = mimeMessage.getHeader(MessageHeaders.HDR_X_MAILER, null);
            if (null == mailer || (noAppleMailer = MimeStructureFixer.toLowerCase(mailer).indexOf("apple") < 0)) {
                MimeMessage mimeMessage3 = mimeMessage;
                return mimeMessage3;
            }
            String boundary = contentType.getParameter("boundary");
            if (noAppleMailer && (null == boundary || MimeStructureFixer.toLowerCase(boundary).indexOf("apple") < 0)) {
                MimeMessage mimeMessage4 = mimeMessage;
                return mimeMessage4;
            }
            if (mimeMessage instanceof ReadableMime) {
                sink = new ThresholdFileHolder();
                mimeMessage.writeTo(sink.asOutputStream());
                File tempFile = sink.getTempFile();
                mime = null == tempFile ? new MimeMessage(MimeDefaultSession.getDefaultSession(), sink.getStream()) : new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), tempFile);
            } else {
                mime = mimeMessage;
            }
            MimeMessage retval = this.process0((MimeMessage)mime, contentType);
            closeSink = false;
            MimeMessage mimeMessage5 = retval;
            return mimeMessage5;
        }
        finally {
            if (closeSink && null != sink) {
                sink.close();
            }
        }
    }

    private MimeMessage process0(MimeMessage mimeMessage, ContentType contentType) throws OXException {
        try {
            String messageId = mimeMessage.getHeader(MESSAGE_ID, null);
            this.handlePart(MimeMessageConverter.multipartFor(mimeMessage, contentType));
            MimeMessageConverter.saveChanges(mimeMessage);
            if (null == messageId) {
                mimeMessage.removeHeader(MESSAGE_ID);
            } else {
                mimeMessage.setHeader(MESSAGE_ID, messageId);
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (MessageRemovedIOException e) {
            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create();
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private void handlePart(Multipart multipart) throws MessagingException, IOException, OXException {
        int count = multipart.getCount();
        if (MimeStructureFixer.toLowerCase(multipart.getContentType()).startsWith("multipart/mixed")) {
            ContentType contentType;
            BodyPart bodyPart;
            int i;
            String prefixImage = "image/";
            String prefixHtm = "text/htm";
            String prefixText = "text/plain";
            int inlineCount = 0;
            int inlineImageCount = 0;
            boolean isHtml = true;
            for (i = 0; i < count; ++i) {
                bodyPart = multipart.getBodyPart(i);
                if (!MimeStructureFixer.isInline((Part)bodyPart, contentType = this.getContentType((Part)bodyPart))) continue;
                if (contentType.startsWith(prefixHtm)) {
                    ++inlineCount;
                    continue;
                }
                if (!contentType.startsWith(prefixImage)) continue;
                ++inlineImageCount;
            }
            if (inlineImageCount > 0 && inlineCount <= 1) {
                inlineCount = 0;
                inlineImageCount = 0;
                isHtml = false;
                for (i = 0; i < count; ++i) {
                    bodyPart = multipart.getBodyPart(i);
                    if (!MimeStructureFixer.isInline((Part)bodyPart, contentType = this.getContentType((Part)bodyPart))) continue;
                    if (contentType.startsWith(prefixText)) {
                        ++inlineCount;
                        continue;
                    }
                    if (!contentType.startsWith(prefixImage)) continue;
                    ++inlineImageCount;
                }
            }
            if (inlineImageCount > 0 && inlineCount > 1) {
                String textContent = null;
                String firstCharset = null;
                ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>(count);
                LinkedList<BodyPart> others = new LinkedList<BodyPart>();
                TIntArrayList indexes = new TIntArrayList(count);
                for (int i2 = 0; i2 < count; ++i2) {
                    BodyPart bodyPart2 = multipart.getBodyPart(i2);
                    ContentType contentType2 = this.getContentType((Part)bodyPart2);
                    if (contentType2.startsWith(isHtml ? prefixHtm : prefixText)) {
                        String charset = MessageUtility.checkCharset((Part)bodyPart2, contentType2);
                        if (null == firstCharset) {
                            firstCharset = charset;
                        }
                        String text = MessageUtility.readMimePart((Part)bodyPart2, charset);
                        textContent = null == textContent ? text : (isHtml ? this.mergeInto(text, textContent) : textContent + text);
                        indexes.add(i2);
                        continue;
                    }
                    if (contentType2.startsWith(prefixImage)) {
                        if (isHtml) {
                            MimeBodyPart imageBodyPart = (MimeBodyPart)bodyPart2;
                            String contentId = imageBodyPart.getHeader("Content-Id", null);
                            if (null == contentId) {
                                contentId = new StringBuilder(48).append('<').append(UUID.randomUUID().toString()).append('>').toString();
                                imageBodyPart.setContentID(contentId);
                            }
                            String text = new StringBuilder(64).append("<img src=\"cid:").append(this.getContentId(contentId)).append("\">").toString();
                            textContent = null == textContent ? text : this.mergeInto(text, textContent);
                        }
                        bodyParts.add(bodyPart2);
                        indexes.add(i2);
                        continue;
                    }
                    if (isHtml) {
                        others.add(bodyPart2);
                    } else {
                        bodyParts.add(bodyPart2);
                    }
                    indexes.add(i2);
                }
                indexes.reverse();
                for (int i3 : indexes.toArray()) {
                    multipart.removeBodyPart(i3);
                }
                if (isHtml) {
                    MimeMultipart newSubMultipart = new MimeMultipart("related");
                    MimeBodyPart contentBodyPart = new MimeBodyPart();
                    String charset = null == firstCharset ? "ISO-8859-1" : firstCharset;
                    contentBodyPart.setText(textContent, charset, "html");
                    contentBodyPart.setHeader(CONTENT_TYPE, MimeMessageUtility.foldContentType("text/html; charset=\"" + charset + "\""));
                    contentBodyPart.setHeader(CONTENT_DISPOSITION, "inline");
                    contentBodyPart.setHeader(MIME_VERSION, "1.0");
                    contentBodyPart.setHeader(CONTENT_TRANSFER_ENC, "quoted-printable");
                    newSubMultipart.addBodyPart((BodyPart)contentBodyPart);
                    for (BodyPart nextBodyPart : bodyParts) {
                        newSubMultipart.addBodyPart(nextBodyPart);
                    }
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    MessageUtility.setContent((Multipart)newSubMultipart, (Part)mimeBodyPart);
                    multipart.addBodyPart((BodyPart)mimeBodyPart, 0);
                } else {
                    MimeBodyPart contentBodyPart = new MimeBodyPart();
                    String charset = null == firstCharset ? "ISO-8859-1" : firstCharset;
                    contentBodyPart.setText(textContent, charset, "plain");
                    contentBodyPart.setHeader(CONTENT_TYPE, MimeMessageUtility.foldContentType("text/plain; charset=\"" + charset + "\""));
                    multipart.addBodyPart((BodyPart)contentBodyPart);
                    contentBodyPart.setHeader(CONTENT_DISPOSITION, "inline");
                    contentBodyPart.setHeader(MIME_VERSION, "1.0");
                    contentBodyPart.setHeader(CONTENT_TRANSFER_ENC, "quoted-printable");
                    for (BodyPart nextBodyPart : bodyParts) {
                        multipart.addBodyPart(nextBodyPart);
                    }
                }
                if (!others.isEmpty()) {
                    for (BodyPart otherBodyPart : others) {
                        multipart.addBodyPart(otherBodyPart);
                    }
                }
                return;
            }
        }
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String sContentType = bodyPart.getContentType();
            if (MimeStructureFixer.isEmpty(sContentType)) continue;
            ContentType contentType = new ContentType(sContentType);
            if (contentType.startsWith("multipart/")) {
                Object content = bodyPart.getContent();
                Object mpContent = content instanceof Multipart ? (Multipart)content : new MimeMultipart(bodyPart.getDataHandler().getDataSource());
                this.handlePart((Multipart)mpContent);
                continue;
            }
            if (!contentType.startsWith("message/rfc822") && (contentType.getNameParameter() == null || !contentType.getNameParameter().endsWith(".eml"))) continue;
            Object content = bodyPart.getContent();
            MimeMessage filteredMessage = content instanceof MimeMessage ? this.process((MimeMessage)content) : this.process(new MimeMessage(MimeDefaultSession.getDefaultSession(), bodyPart.getInputStream()));
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            MessageUtility.setContent((Message)filteredMessage, (Part)mimeBodyPart);
            multipart.removeBodyPart(i);
            multipart.addBodyPart((BodyPart)mimeBodyPart, i);
        }
    }

    private String mergeInto(String anotherHtml, String mainHtml) {
        Matcher mStart = PATTERN_BODY_START.matcher(anotherHtml);
        Matcher mEnd = PATTERN_BODY_END.matcher(anotherHtml);
        if (!mStart.find() || !mEnd.find()) {
            Matcher mMain = PATTERN_BODY_END.matcher(mainHtml);
            if (mMain.find()) {
                StringBuffer sb = new StringBuffer(mainHtml.length() + anotherHtml.length());
                mMain.appendReplacement(sb, Matcher.quoteReplacement(anotherHtml) + Matcher.quoteReplacement(mMain.group()));
                mMain.appendTail(sb);
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder(mainHtml.length() + anotherHtml.length());
            sb.append(mainHtml).append(anotherHtml);
            return sb.toString();
        }
        Matcher mMain = PATTERN_BODY_END.matcher(mainHtml);
        if (mMain.find()) {
            StringBuffer sb = new StringBuffer(mainHtml.length() + anotherHtml.length());
            mMain.appendReplacement(sb, Matcher.quoteReplacement(anotherHtml.substring(mStart.end(), mEnd.start())) + Matcher.quoteReplacement(mMain.group()));
            mMain.appendTail(sb);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(mainHtml.length() + anotherHtml.length());
        sb.append(mainHtml).append(anotherHtml.substring(mStart.end(), mEnd.start()));
        return sb.toString();
    }

    private ContentType getContentType(Part part) throws OXException {
        try {
            String[] tmp = part.getHeader(CONTENT_TYPE);
            return tmp != null && tmp.length > 0 ? new ContentType(tmp[0]) : new ContentType("text/plain; charset=us-ascii");
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private String getContentId(String sContentId) {
        if (null == sContentId) {
            return null;
        }
        if (sContentId.startsWith("<") && sContentId.endsWith(">")) {
            return sContentId.substring(1, sContentId.length() - 1);
        }
        return sContentId;
    }

    private static boolean isInline(Part part, ContentType contentType) throws OXException {
        try {
            boolean hasDisposition;
            ContentDisposition cd;
            String[] hdr = part.getHeader(CONTENT_DISPOSITION);
            if (null == hdr) {
                cd = new ContentDisposition();
                hasDisposition = false;
            } else {
                cd = new ContentDisposition(hdr[0]);
                hasDisposition = true;
            }
            return hasDisposition && "inline".equalsIgnoreCase(cd.getDisposition()) || !hasDisposition && !cd.containsFilenameParameter() && !contentType.containsParameter("name");
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        block3: for (int i = 0; isWhitespace && i < len; ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': {
                    isWhitespace = true;
                    continue block3;
                }
                default: {
                    isWhitespace = false;
                }
            }
        }
        return isWhitespace;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static Map<String, String> getParametersFrom(ContentType contentType, Set<String> exclude) {
        LinkedHashMap<String, String> retval = new LinkedHashMap<String, String>(4);
        if (null == exclude || exclude.isEmpty()) {
            Iterator<String> it = contentType.getParameterNames();
            while (it.hasNext()) {
                String name = it.next();
                retval.put(name, contentType.getParameter(name));
            }
        } else {
            Iterator<String> it = contentType.getParameterNames();
            while (it.hasNext()) {
                String name = it.next();
                if (exclude.contains(name)) continue;
                retval.put(name, contentType.getParameter(name));
            }
        }
        return retval;
    }
}

