/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class FolderParser {
    private static final int[] mapping = new int[]{0, 2, 4, -1, 8};

    private FolderParser() {
    }

    public static void parse(JSONObject jsonObj, MailFolderDescription mailFolder, Session session, int accountId) throws OXException {
        block15: {
            try {
                JSONArray jsonArr;
                int len;
                if (jsonObj.has("title")) {
                    mailFolder.setName(jsonObj.getString("title"));
                }
                if (jsonObj.has("folder_id")) {
                    FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(jsonObj.getString("folder_id"));
                    mailFolder.setParentFullname(arg.getFullname());
                    mailFolder.setParentAccountId(arg.getAccountId());
                }
                if (jsonObj.has("module") && !jsonObj.getString("module").equalsIgnoreCase("mail")) {
                    throw MailExceptionCode.MISSING_PARAMETER.create("module");
                }
                if (jsonObj.hasAndNotNull("subscribed")) {
                    try {
                        mailFolder.setSubscribed(jsonObj.getInt("subscribed") > 0);
                    }
                    catch (JSONException e) {
                        mailFolder.setSubscribed(jsonObj.getBoolean("subscribed"));
                    }
                }
                if (!jsonObj.has("permissions") || jsonObj.isNull("permissions") || (len = (jsonArr = jsonObj.getJSONArray("permissions")).length()) <= 0) break block15;
                ArrayList<MailPermission> mailPerms = new ArrayList<MailPermission>(len);
                UserStorage us = UserStorage.getInstance();
                MailProvider provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                for (int i = 0; i < len; ++i) {
                    int entity;
                    JSONObject elem = jsonArr.getJSONObject(i);
                    if (!elem.has("entity")) {
                        throw MailExceptionCode.MISSING_PARAMETER.create("entity");
                    }
                    try {
                        entity = elem.getInt("entity");
                    }
                    catch (JSONException e) {
                        String entityStr = elem.getString("entity");
                        entity = us.getUserId(entityStr, ContextStorage.getStorageContext(session.getContextId()));
                    }
                    MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                    mailPerm.setEntity(entity);
                    if (!elem.has("bits")) {
                        throw MailExceptionCode.MISSING_PARAMETER.create("bits");
                    }
                    int[] permissionBits = FolderParser.parsePermissionBits(elem.getInt("bits"));
                    if (!mailPerm.setAllPermission(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3])) {
                        throw MailExceptionCode.INVALID_PERMISSION.create(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3]);
                    }
                    mailPerm.setFolderAdmin(permissionBits[4] > 0);
                    if (!elem.has("group")) {
                        throw MailExceptionCode.MISSING_PARAMETER.create("group");
                    }
                    mailPerm.setGroupPermission(elem.getBoolean("group"));
                    mailPerms.add(mailPerm);
                }
                mailFolder.addPermissions(mailPerms);
            }
            catch (JSONException e) {
                throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static int[] parsePermissionBits(int bitsArg) {
        int bits = bitsArg;
        int[] retval = new int[5];
        for (int i = retval.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            retval[i] = bits >> shiftVal;
            bits -= retval[i] << shiftVal;
            retval[i] = retval[i] == 64 ? 128 : (i < retval.length - 1 ? mapping[retval[i]] : retval[i]);
        }
        return retval;
    }
}

