/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json;

import gnu.trove.ConcurrentTIntObjectHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Column {
    private static final ConcurrentTIntObjectHashMap<Column> FIELDS = new ConcurrentTIntObjectHashMap(24);
    private static final ConcurrentMap<String, Column> HEADERS = new ConcurrentHashMap<String, Column>(32);
    private final int field;
    private final String header;

    public static Column field(int field) {
        Column column = (Column)FIELDS.get(field);
        if (null == column) {
            column = new Column(field);
            FIELDS.put(field, (Object)column);
        }
        return column;
    }

    public static Column header(String header) {
        Column column = (Column)HEADERS.get(header);
        if (null == column) {
            column = new Column(header);
            HEADERS.put(header, column);
        }
        return column;
    }

    private Column(int field) {
        this.field = field;
        this.header = null;
    }

    private Column(String header) {
        this.field = -1;
        this.header = header;
    }

    public int getField() {
        return this.field;
    }

    public String getHeader() {
        return this.header;
    }

    public String toString() {
        return this.field > 0 ? Integer.toString(this.field) : (null == this.header ? "null" : this.header);
    }
}

