/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import java.util.Arrays;
import java.util.HashSet;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;

public final class MailcapInitialization {
    private static final MailcapInitialization SINGLETON = new MailcapInitialization();
    private boolean initialized;

    public static MailcapInitialization getInstance() {
        return SINGLETON;
    }

    private MailcapInitialization() {
    }

    public synchronized void init() {
        if (!this.initialized) {
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            HashSet<String> types = new HashSet<String>(Arrays.asList(mc.getMimeTypes()));
            if (!types.contains("text/html")) {
                mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            }
            if (!types.contains("text/xml")) {
                mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            }
            if (!types.contains("text/plain")) {
                mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            }
            if (!types.contains("multipart/*")) {
                mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed; x-java-fallback-entry=true");
            }
            if (!types.contains("message/rfc822")) {
                mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            }
            CommandMap.setDefaultCommandMap((CommandMap)mc);
            this.initialized = true;
        }
    }
}

