/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.image;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.image.ImageActionFactory;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.session.Session;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.jacksum.algorithm.MD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageUtility.class);
    private static final String UTF_8 = "UTF-8";
    private static final Pattern SPLIT = Pattern.compile("&amp;|&");
    private static final Map<String, ValueHandler> NVP_HANDLERS;
    private static final int RADIX = 10;

    private ImageUtility() {
    }

    public static ImageLocation parseImageLocationFrom(String imageUri) {
        if (null == imageUri) {
            return null;
        }
        int queryStringStart = imageUri.indexOf(63);
        if (queryStringStart < 0) {
            return new ImageLocation(new ImageLocation.Builder());
        }
        String[] nvps = SPLIT.split(imageUri.substring(queryStringStart + 1), 0);
        ImageLocation.Builder builder = new ImageLocation.Builder();
        for (String nvp : nvps) {
            String name;
            ValueHandler handler;
            int pos = (nvp = nvp.trim()).indexOf(61);
            if (pos < 0 || null == (handler = NVP_HANDLERS.get(name = Strings.asciiLowerCase((String)nvp.substring(0, pos))))) continue;
            handler.handleValue(ImageUtility.decodeQueryStringValue(nvp.substring(pos + 1)), builder);
        }
        ImageLocation il = builder.build();
        String registrationName = builder.registrationName;
        if (null == registrationName && null == (registrationName = ImageActionFactory.getRegistrationNameFor(imageUri))) {
            throw new IllegalArgumentException("No known registration name for: " + imageUri);
        }
        il.setRegistrationName(registrationName);
        return il;
    }

    public static ImageLocation parseImageLocationFrom(AJAXRequestData requestData) {
        if (requestData == null) {
            return null;
        }
        String accountId = requestData.getParameter("accountId");
        String folder = requestData.getParameter("folder");
        String id = requestData.getParameter("id");
        String imageId = requestData.getParameter("uid");
        String timestamp = requestData.getParameter("timestamp");
        String registrationName = requestData.getParameter("source");
        ImageLocation il = new ImageLocation.Builder(imageId).accountId(accountId).folder(folder).id(id).timestamp(timestamp).build();
        if (null == registrationName && null == (registrationName = ImageActionFactory.getRegistrationNameFor(requestData.getSerlvetRequestURI()))) {
            throw new IllegalArgumentException("No known registration name for: " + requestData.getSerlvetRequestURI());
        }
        il.setRegistrationName(registrationName);
        return il;
    }

    private static String decodeQueryStringValue(String queryStringValue) {
        try {
            return AJAXUtility.decodeUrl(queryStringValue, UTF_8);
        }
        catch (RuntimeException e) {
            return queryStringValue;
        }
    }

    public static void startImageUrl(ImageLocation imageLocation, Session session, ImageDataSource imageDataSource, boolean preferRelativeUrl, StringBuilder sb) {
        ImageUtility.startImageUrl(imageLocation, session, imageDataSource, preferRelativeUrl, false, sb);
    }

    public static void startImageUrl(ImageLocation imageLocation, Session session, ImageDataSource imageDataSource, boolean preferRelativeUrl, boolean addRoute, StringBuilder sb) {
        String accountId;
        String timestamp;
        String imageId;
        String objectId;
        String folder;
        Boolean noRoute;
        String route;
        String prefix;
        String optImageHost;
        boolean optImageHostSet = false;
        String publicSessionId = null;
        HostData hostData = (HostData)session.getParameter("com.openexchange.groupware.hostdata");
        if (hostData == null) {
            optImageHost = imageLocation.getOptImageHost();
            if (Strings.isEmpty((String)optImageHost)) {
                prefix = "";
            } else {
                publicSessionId = (String)session.getParameter(Session.PARAM_ALTERNATIVE_ID);
                if (Strings.isEmpty((String)publicSessionId)) {
                    LOGGER.warn("Cannot use configured image host \"{}\" as associated session has no public session identifier set.", (Object)optImageHost);
                    prefix = "";
                } else {
                    String tmp = Strings.toLowerCase((CharSequence)optImageHost);
                    prefix = tmp.startsWith("http") ? optImageHost : new StringBuilder(32).append("http://").append(optImageHost).toString();
                    optImageHostSet = true;
                }
            }
            String ajpRoute = LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.AJP_HTTP_SESSION);
            route = null == ajpRoute ? LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.GRIZZLY_HTTP_SESSION) : ajpRoute;
        } else {
            optImageHost = imageLocation.getOptImageHost();
            if (Strings.isEmpty((String)optImageHost)) {
                if (preferRelativeUrl) {
                    prefix = "";
                } else {
                    sb.append(hostData.isSecure() ? "https://" : "http://");
                    sb.append(hostData.getHost());
                    int port = hostData.getPort();
                    if (hostData.isSecure() && port != 443 || !hostData.isSecure() && port != 80) {
                        sb.append(':').append(port);
                    }
                    prefix = sb.toString();
                    sb.setLength(0);
                }
            } else {
                publicSessionId = (String)session.getParameter(Session.PARAM_ALTERNATIVE_ID);
                if (Strings.isEmpty((String)publicSessionId)) {
                    LOGGER.warn("Cannot use configured image host \"{}\" as associated session has no public session identifier set.", (Object)optImageHost);
                    if (preferRelativeUrl) {
                        prefix = "";
                    } else {
                        sb.append(hostData.isSecure() ? "https://" : "http://");
                        sb.append(hostData.getHost());
                        int port = hostData.getPort();
                        if (hostData.isSecure() && port != 443 || !hostData.isSecure() && port != 80) {
                            sb.append(':').append(port);
                        }
                        prefix = sb.toString();
                        sb.setLength(0);
                    }
                } else {
                    String tmp = Strings.toLowerCase((CharSequence)optImageHost);
                    prefix = tmp.startsWith("http") ? optImageHost : new StringBuilder(32).append("http://").append(optImageHost).toString();
                    optImageHostSet = true;
                }
            }
            route = hostData.getRoute();
        }
        sb.append(prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix);
        sb.append(DefaultDispatcherPrefixService.getInstance().getPrefix());
        sb.append("image");
        String alias = imageDataSource.getAlias();
        if (null != alias) {
            sb.append(alias);
        }
        if (optImageHostSet) {
            if (null != route) {
                sb.append(";jsessionid=").append(route);
            }
        } else if (addRoute && (null == (noRoute = (Boolean)imageLocation.getProperty("__noRoute")) || !noRoute.booleanValue()) && null != route) {
            sb.append(";jsessionid=").append(route);
        }
        boolean first = true;
        if (null != publicSessionId) {
            sb.append('?').append("public_session").append('=').append(ImageUtility.urlEncodeSafe(publicSessionId));
            first = false;
        }
        if (null == alias) {
            sb.append(first ? (char)'?' : '&').append("source=").append(ImageUtility.urlEncodeSafe(imageDataSource.getRegistrationName()));
            first = false;
        }
        if (null != (folder = imageLocation.getFolder())) {
            sb.append(first ? (char)'?' : '&').append("folder").append('=').append(ImageUtility.urlEncodeSafe(folder));
            first = false;
        }
        if (null != (objectId = imageLocation.getId())) {
            sb.append(first ? (char)'?' : '&').append("id").append('=').append(ImageUtility.urlEncodeSafe(objectId));
            first = false;
        }
        if (null != (imageId = imageLocation.getImageId())) {
            sb.append(first ? (char)'?' : '&').append("uid").append('=').append(ImageUtility.urlEncodeSafe(imageId));
            first = false;
        }
        if (null != (timestamp = imageLocation.getTimestamp())) {
            sb.append(first ? (char)'?' : '&').append("timestamp").append('=').append(ImageUtility.urlEncodeSafe(timestamp));
            first = false;
        }
        if (null != (accountId = imageLocation.getAccountId())) {
            sb.append(first ? (char)'?' : '&').append("accountId=").append(ImageUtility.urlEncodeSafe(accountId));
            first = false;
        }
    }

    private static String urlEncodeSafe(String text) {
        try {
            return URLEncoder.encode(text, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(ImageUtility.class).error("", (Throwable)e);
            return text;
        }
    }

    public static String getMD5(String string, String encoding) {
        try {
            MD checksum = new MD("MD5");
            checksum.setEncoding(encoding);
            checksum.update(string.getBytes(Charsets.UTF_8));
            return checksum.getFormattedValue();
        }
        catch (NoSuchAlgorithmException e) {
            LoggerFactory.getLogger(ImageUtility.class).error("", (Throwable)e);
            return null;
        }
    }

    public static String getHash(String string, String algorithm, String encoding) {
        try {
            AbstractChecksum checksum = JacksumAPI.getChecksumInstance((String)algorithm);
            checksum.setEncoding(encoding);
            checksum.update(string.getBytes(UTF_8));
            return checksum.getFormattedValue();
        }
        catch (NoSuchAlgorithmException e) {
            LoggerFactory.getLogger(ImageUtility.class).error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(ImageUtility.class).error("", (Throwable)e);
        }
        return null;
    }

    public static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int limit = -2147483647;
        int multmin = -214748364;
        int result = 0;
        int i = 0;
        if (i < max) {
            if ((digit = ImageUtility.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = ImageUtility.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    static {
        HashMap<String, ValueHandler> map = new HashMap<String, ValueHandler>(8);
        map.put("accountId", new ValueHandler(){

            @Override
            public void handleValue(String value, ImageLocation.Builder builder) {
                builder.accountId(value);
            }
        });
        map.put("folder", new ValueHandler(){

            @Override
            public void handleValue(String value, ImageLocation.Builder builder) {
                builder.folder(value);
            }
        });
        map.put("id", new ValueHandler(){

            @Override
            public void handleValue(String value, ImageLocation.Builder builder) {
                builder.id(value);
            }
        });
        map.put("uid", new ValueHandler(){

            @Override
            public void handleValue(String value, ImageLocation.Builder builder) {
                builder.imageId(value);
            }
        });
        map.put("timestamp", new ValueHandler(){

            @Override
            public void handleValue(String value, ImageLocation.Builder builder) {
                builder.timestamp(value);
            }
        });
        map.put("source", new ValueHandler(){

            @Override
            public void handleValue(String value, ImageLocation.Builder builder) {
                builder.registrationName(value);
            }
        });
        NVP_HANDLERS = map;
    }

    private static interface ValueHandler {
        public void handleValue(String var1, ImageLocation.Builder var2);
    }
}

