/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration.osgi;

import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.userconfiguration.Permission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.userconf.UserPermissionService;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CapabilityRegistrationListener
implements ServiceTrackerCustomizer<CapabilityService, CapabilityService> {
    private final BundleContext context;
    private volatile ServiceRegistration<CapabilityChecker> checkerRegistration1;
    private volatile ServiceRegistration<CapabilityChecker> checkerRegistration2;

    public CapabilityRegistrationListener(BundleContext context) {
        this.context = context;
    }

    public CapabilityService addingService(ServiceReference<CapabilityService> ref) {
        CapabilityService capabilityService = (CapabilityService)this.context.getService(ref);
        ServerServiceRegistry.getInstance().addService(CapabilityService.class, capabilityService);
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        final String sCapability = Permission.EDIT_GROUP.getCapabilityName();
        ((Dictionary)properties).put("capabilities", sCapability);
        this.checkerRegistration1 = this.context.registerService(CapabilityChecker.class, (Object)new CapabilityChecker(){

            public boolean isEnabled(String capability, Session session) throws OXException {
                if (sCapability.equals(capability)) {
                    if (session.getUserId() <= 0) {
                        return false;
                    }
                    if (null == ConfigTree.getInstance().optSettingByPath("modules/com.openexchange.group")) {
                        return false;
                    }
                    UserPermissionService permissionService = ServerServiceRegistry.getInstance().getService(UserPermissionService.class);
                    return permissionService.getUserPermissionBits(session.getUserId(), session.getContextId()).isEditGroup();
                }
                return true;
            }
        }, properties);
        capabilityService.declareCapability(sCapability);
        properties = new Hashtable(1);
        sCapability = Permission.EDIT_RESOURCE.getCapabilityName();
        ((Dictionary)properties).put("capabilities", sCapability);
        this.checkerRegistration2 = this.context.registerService(CapabilityChecker.class, (Object)new CapabilityChecker(){

            public boolean isEnabled(String capability, Session session) throws OXException {
                if (sCapability.equals(capability)) {
                    if (session.getUserId() <= 0) {
                        return false;
                    }
                    if (null == ConfigTree.getInstance().optSettingByPath("modules/com.openexchange.resource")) {
                        return false;
                    }
                    UserPermissionService permissionService = ServerServiceRegistry.getInstance().getService(UserPermissionService.class);
                    return permissionService.getUserPermissionBits(session.getUserId(), session.getContextId()).isEditResource();
                }
                return true;
            }
        }, properties);
        capabilityService.declareCapability(sCapability);
        return capabilityService;
    }

    public void modifiedService(ServiceReference<CapabilityService> reference, CapabilityService capabilityService) {
    }

    public void removedService(ServiceReference<CapabilityService> reference, CapabilityService capabilityService) {
        ServiceRegistration<CapabilityChecker> registration = this.checkerRegistration1;
        if (registration != null) {
            registration.unregister();
            this.checkerRegistration1 = null;
        }
        if ((registration = this.checkerRegistration2) != null) {
            registration.unregister();
            this.checkerRegistration2 = null;
        }
        capabilityService.undeclareCapability(Permission.EDIT_GROUP.getCapabilityName());
        capabilityService.undeclareCapability(Permission.EDIT_RESOURCE.getCapabilityName());
        ServerServiceRegistry.getInstance().removeService(CapabilityService.class);
        this.context.ungetService(reference);
    }
}

