/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.ContactsAddUseCountColumnUpdateTask;
import com.openexchange.server.services.I18nServices;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameGroupTask
extends UpdateTaskAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(RenameGroupTask.class);
    private static final String[] DEPENDENCIES = new String[]{ContactsAddUseCountColumnUpdateTask.class.getName()};

    @Override
    public int addedWithVersion() {
        return 52;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            int[] ctxIds = Database.getContextsInSameSchema(contextId);
            ProgressState state = params.getProgressState();
            state.setTotal(ctxIds.length);
            for (int context : ctxIds) {
                String adminLanguage = this.getContextAdminLanguage(con, context);
                String groupName = I18nServices.getInstance().translate(adminLanguage, "Standard group");
                this.updateGroupName(con, context, groupName);
                state.incrementState();
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroupName(Connection con, int context, String groupName) {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE groups SET displayName=? WHERE cid=? AND id=1");
            stmt.setString(1, groupName);
            stmt.setInt(2, context);
            int count = stmt.executeUpdate();
            if (1 != count) {
                LOG.warn("Was not able to update display name of standard group.");
            }
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContextAdminLanguage(Connection con, int contextId) {
        PreparedStatement stmt = null;
        ResultSet result = null;
        String language = "en_US";
        try {
            stmt = con.prepareStatement("SELECT u.preferredLanguage FROM user u JOIN user_setting_admin a ON u.cid=a.cid AND u.id=a.user WHERE a.cid=?");
            stmt.setInt(1, contextId);
            result = stmt.executeQuery();
            if (result.next()) {
                language = result.getString(1);
            }
            DBUtils.closeSQLStuff(result, stmt);
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(result, stmt);
        }
        return language;
    }
}

