/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class CheckAndDropDateExternalForeignKeysUpdateTask
extends UpdateTaskAdapter {
    private static final String PRG_DATES = "prg_dates";
    private static final String DATE_EXTERNAL = "dateExternal";
    private static final String DEL_DATES = "del_dates";
    private static final String DEL_DATE_EXTERNAL = "delDateExternal";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        try {
            String delForeignKey;
            con.setAutoCommit(false);
            String prgForeignKey = Tools.existsForeignKey(con, PRG_DATES, new String[]{"cid", "intfield01"}, DATE_EXTERNAL, new String[]{"cid", "objectId"});
            if (null != prgForeignKey && !prgForeignKey.equals("")) {
                Tools.dropForeignKey(con, DATE_EXTERNAL, prgForeignKey);
            }
            if (null != (delForeignKey = Tools.existsForeignKey(con, DEL_DATES, new String[]{"cid", "intfield01"}, DEL_DATE_EXTERNAL, new String[]{"cid", "objectId"})) && !delForeignKey.equals("")) {
                Tools.dropForeignKey(con, DEL_DATE_EXTERNAL, delForeignKey);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.DelDatesPrimaryKeyUpdateTask", "com.openexchange.groupware.update.tasks.PrgDatesPrimaryKeyUpdateTask"};
    }
}

