/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public final class CalendarAddUIDValueTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(cid);
        try {
            con.setAutoCommit(false);
            this.addUidSingleAppoointments("prg_dates", con);
            this.addUidRecurringAppoointments("prg_dates", con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUidSingleAppoointments(final String tableName, final Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement("SELECT intfield01,cid FROM " + tableName + " WHERE uid IS NULL AND intfield02 IS NULL");
            resultSet = stmt.executeQuery();
            TIntObjectHashMap map = new TIntObjectHashMap(1024);
            while (resultSet.next()) {
                int cid = resultSet.getInt(2);
                TIntList ids = (TIntList)map.get(cid);
                if (null == ids) {
                    ids = new TIntLinkedList();
                    map.put(cid, (Object)ids);
                }
                ids.add(resultSet.getInt(1));
            }
            DBUtils.closeSQLStuff(resultSet, stmt);
            final AtomicReference exceptionReference = new AtomicReference();
            map.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntList>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute(final int cid, TIntList ids) {
                    PreparedStatement innerStmt = null;
                    try {
                        final PreparedStatement pStmt = innerStmt = con.prepareStatement("UPDATE " + tableName + " SET uid=? WHERE cid=? AND intfield01=?");
                        ids.forEach(new TIntProcedure(){

                            public boolean execute(int id) {
                                try {
                                    pStmt.setString(1, UUID.randomUUID().toString());
                                    pStmt.setInt(2, cid);
                                    pStmt.setInt(3, id);
                                    pStmt.addBatch();
                                    return true;
                                }
                                catch (SQLException e) {
                                    exceptionReference.set(e);
                                    return false;
                                }
                            }
                        });
                        SQLException sqlException = (SQLException)exceptionReference.get();
                        if (null != sqlException) {
                            throw sqlException;
                        }
                        innerStmt.executeBatch();
                        boolean bl = true;
                        DBUtils.closeSQLStuff(innerStmt);
                        return bl;
                    }
                    catch (SQLException e) {
                        exceptionReference.set(e);
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        DBUtils.closeSQLStuff(innerStmt);
                    }
                }
            });
            SQLException sqlException = (SQLException)exceptionReference.get();
            if (null != sqlException) {
                throw sqlException;
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUidRecurringAppoointments(final String tableName, final Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement("SELECT intfield01,cid FROM " + tableName + " WHERE uid IS NULL AND intfield01=intfield02");
            resultSet = stmt.executeQuery();
            TIntObjectHashMap map = new TIntObjectHashMap(1024);
            while (resultSet.next()) {
                int cid = resultSet.getInt(2);
                TIntList ids = (TIntList)map.get(cid);
                if (null == ids) {
                    ids = new TIntLinkedList();
                    map.put(cid, (Object)ids);
                }
                ids.add(resultSet.getInt(1));
            }
            DBUtils.closeSQLStuff(resultSet, stmt);
            final AtomicReference exceptionReference = new AtomicReference();
            map.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntList>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute(final int cid, TIntList ids) {
                    boolean bl;
                    PreparedStatement innerStmtMaster = null;
                    PreparedStatement innerStmtExceptions = null;
                    try {
                        innerStmtMaster = con.prepareStatement("UPDATE " + tableName + " SET uid=? WHERE cid=? AND intfield01=?");
                        innerStmtExceptions = con.prepareStatement("UPDATE " + tableName + " SET uid=? WHERE cid=? AND intfield02=?");
                        final PreparedStatement stmtMaster = innerStmtMaster;
                        final PreparedStatement stmtExceptions = innerStmtExceptions;
                        ids.forEach(new TIntProcedure(){

                            public boolean execute(int id) {
                                String uuid = UUID.randomUUID().toString();
                                try {
                                    stmtMaster.setString(1, uuid);
                                    stmtMaster.setInt(2, cid);
                                    stmtMaster.setInt(3, id);
                                    stmtMaster.addBatch();
                                    stmtExceptions.setString(1, uuid);
                                    stmtExceptions.setInt(2, cid);
                                    stmtExceptions.setInt(3, id);
                                    stmtExceptions.addBatch();
                                    return true;
                                }
                                catch (SQLException e) {
                                    exceptionReference.set(e);
                                    return false;
                                }
                            }
                        });
                        SQLException sqlException = (SQLException)exceptionReference.get();
                        if (null != sqlException) {
                            throw sqlException;
                        }
                        innerStmtMaster.executeBatch();
                        innerStmtExceptions.executeBatch();
                        bl = true;
                        DBUtils.closeSQLStuff(innerStmtMaster);
                    }
                    catch (SQLException e) {
                        exceptionReference.set(e);
                        boolean bl2 = false;
                        return bl2;
                    }
                    finally {
                        DBUtils.closeSQLStuff(innerStmtMaster);
                        DBUtils.closeSQLStuff(innerStmtExceptions);
                    }
                    DBUtils.closeSQLStuff(innerStmtExceptions);
                    return bl;
                }
            });
            SQLException sqlException = (SQLException)exceptionReference.get();
            if (null != sqlException) {
                throw sqlException;
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, stmt);
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

