/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAppointmentParticipantsIndexTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(AddAppointmentParticipantsIndexTask.class);

    @Override
    public int addedWithVersion() {
        return 34;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.correctAppointmentParticipantIndexes(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void correctAppointmentParticipantIndexes(Connection con) {
        String[] columns = new String[]{"cid", "member_uid", "object_id"};
        for (String table : new String[]{"prg_dates_members", "del_dates_members"}) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    LOG.info("Creating new index named member with columns (cid,member_uid,object_id) on table {}.", (Object)table);
                    Tools.createIndex(con, table, "member", columns, true);
                    continue;
                }
                LOG.info("New unique index named {} with columns (cid,member_uid,object_id) already exists on table {}.", (Object)indexName, (Object)table);
            }
            catch (SQLException e) {
                LOG.error("Problem correcting indexes on table {}.", (Object)table, (Object)e);
            }
        }
    }
}

