/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.annotation.Nullable;
import com.openexchange.i18n.I18nService;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Translator {
    private static final Translator SINGLETON = new Translator();
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>();

    private Translator() {
    }

    public static final Translator getInstance() {
        return SINGLETON;
    }

    public void addService(I18nService service) {
        this.services.put(service.getLocale(), service);
    }

    public void removeService(I18nService service) {
        this.services.remove(service.getLocale());
    }

    public String translate(@Nullable Locale locale, String toTranslate) {
        if (null == locale) {
            return toTranslate;
        }
        I18nService service = this.services.get(locale);
        if (null == service) {
            return toTranslate;
        }
        if (!service.hasKey(toTranslate)) {
            return toTranslate;
        }
        return service.getLocalized(toTranslate);
    }
}

