/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.quota.AccountQuota;
import com.openexchange.quota.DefaultAccountQuota;
import com.openexchange.quota.Quota;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.quota.QuotaType;
import com.openexchange.quota.groupware.AmountQuotas;
import com.openexchange.session.Session;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class TaskQuotaProvider
implements QuotaProvider {
    private static final String MODULE_ID = "task";
    private final DatabaseService dbService;
    private final ConfigViewFactory viewFactory;

    public TaskQuotaProvider(DatabaseService dbService, ConfigViewFactory viewFactory) {
        this.dbService = dbService;
        this.viewFactory = viewFactory;
    }

    public String getModuleID() {
        return MODULE_ID;
    }

    public String getDisplayName() {
        return "Tasks";
    }

    Quota getAmountQuota(Session session) throws OXException {
        int contextID = session.getContextId();
        Connection connection = this.dbService.getReadOnly(contextID);
        try {
            long limit = AmountQuotas.getLimit((Session)session, (String)MODULE_ID, (ConfigViewFactory)this.viewFactory, (Connection)connection);
            if (limit == -1L) {
                Quota quota = Quota.UNLIMITED_AMOUNT;
                return quota;
            }
            int usage = TaskStorage.getInstance().countTasks(contextID, connection);
            Quota quota = new Quota(QuotaType.AMOUNT, limit, (long)usage);
            return quota;
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            this.dbService.backReadOnly(contextID, connection);
        }
    }

    public AccountQuota getFor(Session session, String accountID) throws OXException {
        if ("0".equals(accountID)) {
            return new DefaultAccountQuota(accountID, this.getDisplayName()).addQuota(this.getAmountQuota(session));
        }
        throw QuotaExceptionCodes.UNKNOWN_ACCOUNT.create(new Object[]{accountID, MODULE_ID});
    }

    public List<AccountQuota> getFor(Session session) throws OXException {
        return Collections.singletonList(this.getFor(session, "0"));
    }
}

