/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.infostore.folder;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trash
implements PreferencesItemService {
    private static final Logger LOG = LoggerFactory.getLogger(Trash.class);
    private static final String DEFAULT_ID = "0";

    @Override
    public String[] getPath() {
        return new String[]{"modules", "infostore", "folder", "trash"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasInfostore();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                long start = System.currentTimeMillis();
                if (InfostoreFacades.isInfoStoreAvailable()) {
                    LOG.debug("After InfostoreFacades.isInfoStoreAvailable(): {}ms", (Object)(System.currentTimeMillis() - start));
                    FolderObject trashFolder = new OXFolderAccess(ctx).getDefaultFolder(user.getId(), 8, 16);
                    LOG.debug("After OXFolderAccess(ctx).getDefaultFolder(): {}ms", (Object)(System.currentTimeMillis() - start));
                    if (null != trashFolder) {
                        setting.setSingleValue(trashFolder.getObjectID());
                    }
                    return;
                }
                FileStorageAccountManagerLookupService accountLookupService = ServerServiceRegistry.getServize(FileStorageAccountManagerLookupService.class);
                if (null == accountLookupService) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{FileStorageAccountManagerLookupService.class.getName()});
                }
                try {
                    FileStorageAccountManager defaultAccountManager = accountLookupService.getAccountManager(Trash.DEFAULT_ID, session);
                    if (null != defaultAccountManager) {
                        FileStorageAccount defaultAccount = defaultAccountManager.getAccount(Trash.DEFAULT_ID, session);
                        FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                        FileStorageAccountAccess accountAccess = fileStorageService.getAccountAccess(Trash.DEFAULT_ID, session);
                        accountAccess.connect();
                        try {
                            FileStorageFolder trashFolder = accountAccess.getFolderAccess().getTrashFolder();
                            setting.setSingleValue(new FolderID(fileStorageService.getId(), defaultAccount.getId(), trashFolder.getId()).toUniqueID());
                            return;
                        }
                        finally {
                            accountAccess.close();
                        }
                    }
                }
                catch (OXException e) {
                    LOG.error("Infostore trash folder could not be applied to user configuration.", (Throwable)e);
                }
            }
        };
    }
}

