/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.WebdavFolderAliases;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.webdav.FolderLockHelper;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.groupware.infostore.webdav.OXWebdavResource;
import com.openexchange.groupware.infostore.webdav.PropertyHelper;
import com.openexchange.groupware.infostore.webdav.URLCache;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.AbstractCollection;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderCollection
extends AbstractCollection
implements OXWebdavResource {
    private static final Logger LOG = LoggerFactory.getLogger(FolderCollection.class);
    private final InfostoreWebdavFactory factory;
    private WebdavPath url;
    private final PropertyHelper propertyHelper;
    private final SessionHolder sessionHolder;
    private final FolderLockHelper lockHelper;
    private FolderObject folder;
    private int id;
    private boolean exists;
    private boolean loaded;
    private final DBProvider provider;
    private final Set<OXWebdavResource> children = new HashSet<OXWebdavResource>();
    private boolean loadedChildren;
    private ArrayList<OCLPermission> overrideNewACL;
    private final InfostoreSecurity security;
    private final WebdavFolderAliases aliases;

    public FolderCollection(WebdavPath url, InfostoreWebdavFactory factory) {
        this(url, factory, null);
    }

    public FolderCollection(WebdavPath url, InfostoreWebdavFactory factory, FolderObject folder) {
        this.url = url;
        this.factory = factory;
        this.sessionHolder = factory.getSessionHolder();
        this.propertyHelper = new PropertyHelper(factory.getFolderProperties(), this.sessionHolder, url);
        this.lockHelper = new FolderLockHelper(factory.getFolderLockManager(), this.sessionHolder, url);
        this.security = factory.getSecurity();
        this.provider = factory.getProvider();
        this.aliases = factory.getAliases();
        if (folder != null) {
            this.setId(folder.getObjectID());
            this.folder = folder;
            this.loaded = true;
            this.exists = true;
        }
    }

    @Override
    public void delete() throws WebdavProtocolException {
        if (!this.exists) {
            return;
        }
        Connection con = null;
        try {
            con = this.provider.getWriteConnection(this.getSession().getContext());
            OXFolderManager oxma = OXFolderManager.getInstance(this.getSession(), con, con);
            oxma.deleteFolder(new FolderObject(this.id), true, System.currentTimeMillis());
            this.exists = false;
            this.factory.removed(this);
        }
        catch (OXException x) {
            if (this.isPermissionException(x)) {
                throw WebdavProtocolException.generalError(x, this.url, 403);
            }
            throw WebdavProtocolException.generalError(x, this.url, 500);
        }
        catch (Exception e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
        finally {
            if (con != null) {
                this.provider.releaseWriteConnection(this.getSession().getContext(), con);
            }
        }
        HashSet<OXWebdavResource> set = new HashSet<OXWebdavResource>(this.children);
        for (OXWebdavResource res : set) {
            res.removedParent();
        }
    }

    private WebdavResource mergeTo(FolderCollection to, boolean move, boolean overwrite) throws WebdavProtocolException {
        int lengthUrl = this.getUrl().size();
        for (WebdavResource res : this.getChildren()) {
            WebdavPath toUrl = to.getUrl().dup().append(res.getUrl().subpath(lengthUrl));
            if (move) {
                res.move(toUrl, false, overwrite);
                continue;
            }
            res.copy(toUrl, false, overwrite);
        }
        return this;
    }

    @Override
    public WebdavResource move(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        FolderCollection coll = (FolderCollection)this.factory.resolveCollection(dest);
        if (coll.exists()) {
            if (overwrite) {
                this.loadFolder();
                ArrayList<OCLPermission> override = new ArrayList<OCLPermission>();
                for (OCLPermission perm : this.folder.getPermissions()) {
                    override.add(perm.deepClone());
                }
                coll.loadFolder();
                coll.folder.setPermissions(override);
                coll.save();
            }
            WebdavResource moved = this.mergeTo(coll, true, overwrite);
            this.delete();
            return moved;
        }
        this.loadFolder();
        String name = dest.name();
        int parentId = ((OXWebdavResource)((Object)coll.parent())).getId();
        this.folder.setFolderName(name);
        this.folder.setParentFolderID(parentId);
        this.invalidate();
        this.factory.invalidate(this.url, this.id, URLCache.Type.COLLECTION);
        this.factory.invalidate(dest, this.id, URLCache.Type.COLLECTION);
        this.url = dest;
        this.save();
        try {
            this.lockHelper.deleteLocks();
        }
        catch (OXException e) {
            throw WebdavProtocolException.generalError(this.getUrl(), 500);
        }
        return this;
    }

    @Override
    public WebdavResource copy(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        FolderCollection coll = (FolderCollection)this.factory.resolveCollection(dest);
        if (coll.exists()) {
            if (overwrite) {
                ArrayList<OCLPermission> override = new ArrayList<OCLPermission>();
                this.loadFolder();
                for (OCLPermission perm : this.folder.getPermissions()) {
                    override.add(perm.deepClone());
                }
                coll.loadFolder();
                coll.folder.setPermissions(override);
                coll.save();
            }
        } else {
            this.loadFolder();
            ArrayList<OCLPermission> override = new ArrayList<OCLPermission>();
            for (OCLPermission perm : this.folder.getPermissions()) {
                override.add(perm.deepClone());
            }
            coll.overrideNewACL = override;
            coll.create();
            this.copyProperties(coll);
        }
        return this.mergeTo(coll, false, overwrite);
    }

    private void copyProperties(FolderCollection coll) throws WebdavProtocolException {
        for (WebdavProperty prop : this.internalGetAllProps()) {
            coll.putProperty(prop);
        }
    }

    @Override
    protected WebdavCollection parent() throws WebdavProtocolException {
        if (this.url != null) {
            return super.parent();
        }
        this.loadFolder();
        return (WebdavCollection)((Object)this.factory.getCollections(Arrays.asList(this.folder.getParentFolderID())).iterator().next());
    }

    private void invalidate() {
        for (OXWebdavResource res : this.children) {
            URLCache.Type t = URLCache.Type.RESOURCE;
            if (res.isCollection()) {
                ((FolderCollection)res).invalidate();
                t = URLCache.Type.COLLECTION;
            }
            this.factory.invalidate(res.getUrl(), res.getId(), t);
        }
    }

    @Override
    protected void internalDelete() {
        throw new IllegalStateException("Should be called only by superclass");
    }

    @Override
    protected WebdavFactory getFactory() {
        return this.factory;
    }

    @Override
    protected List<WebdavProperty> internalGetAllProps() throws WebdavProtocolException {
        return this.propertyHelper.getAllProps();
    }

    @Override
    protected WebdavProperty internalGetProperty(String namespace, String name) throws WebdavProtocolException {
        return this.propertyHelper.getProperty(namespace, name);
    }

    @Override
    protected void internalPutProperty(WebdavProperty prop) throws WebdavProtocolException {
        this.propertyHelper.putProperty(prop);
    }

    @Override
    protected void internalRemoveProperty(String namespace, String name) throws WebdavProtocolException {
        this.propertyHelper.removeProperty(namespace, name);
    }

    @Override
    protected boolean isset(Protocol.Property p) {
        if (p.getId() == 3 || p.getId() == 4 || p.getId() == 6) {
            return false;
        }
        return !this.propertyHelper.isRemoved(new WebdavProperty(p.getNamespace(), p.getName()));
    }

    @Override
    public void setCreationDate(Date date) throws WebdavProtocolException {
        this.folder.setCreationDate(date);
    }

    @Override
    public List<WebdavResource> getChildren() throws WebdavProtocolException {
        this.loadChildren();
        return new ArrayList<WebdavResource>(this.children);
    }

    @Override
    public void create() throws WebdavProtocolException {
        if (this.exists) {
            throw WebdavProtocolException.Code.DIRECTORY_ALREADY_EXISTS.create(this.getUrl(), 405);
        }
        this.save();
        this.exists = true;
        this.factory.created(this);
    }

    @Override
    public boolean exists() throws WebdavProtocolException {
        return this.exists;
    }

    @Override
    public Date getCreationDate() throws WebdavProtocolException {
        this.loadFolder();
        return this.folder.getCreationDate();
    }

    @Override
    public String getDisplayName() throws WebdavProtocolException {
        this.loadFolder();
        return this.getFolderName(this.folder);
    }

    @Override
    public Date getLastModified() throws WebdavProtocolException {
        this.loadFolder();
        return this.folder.getLastModified();
    }

    @Override
    public WebdavLock getLock(String token) throws WebdavProtocolException {
        WebdavLock lock = this.lockHelper.getLock(token);
        if (lock != null) {
            return lock;
        }
        return this.findParentLock(token);
    }

    @Override
    public List<WebdavLock> getLocks() throws WebdavProtocolException {
        List<WebdavLock> lockList = this.getOwnLocks();
        this.addParentLocks(lockList);
        return lockList;
    }

    @Override
    public WebdavLock getOwnLock(String token) throws WebdavProtocolException {
        return this.lockHelper.getLock(token);
    }

    @Override
    public List<WebdavLock> getOwnLocks() throws WebdavProtocolException {
        return this.lockHelper.getAllLocks();
    }

    @Override
    public String getSource() throws WebdavProtocolException {
        return null;
    }

    @Override
    public WebdavPath getUrl() {
        if (this.url == null) {
            this.initUrl();
        }
        return this.url;
    }

    @Override
    public void lock(WebdavLock lock) throws WebdavProtocolException {
        this.lockHelper.addLock(lock);
    }

    @Override
    public void save() throws WebdavProtocolException {
        try {
            this.dumpToDB();
            if (this.propertyHelper.mustWrite()) {
                ServerSession session = this.getSession();
                EffectivePermission perm = this.security.getFolderPermission(this.getId(), session.getContext(), UserStorage.getInstance().getUser(session.getUserId(), session.getContext()), UserPermissionBitsStorage.getInstance().getUserPermissionBits(session.getUserId(), session.getContext()));
                if (!perm.isFolderAdmin()) {
                    throw WebdavProtocolException.Code.NO_WRITE_PERMISSION.create(this.getUrl(), 403);
                }
            }
            this.propertyHelper.dumpPropertiesToDB();
            this.lockHelper.dumpLocksToDB();
            this.exists = true;
        }
        catch (WebdavProtocolException x) {
            throw x;
        }
        catch (Exception x) {
            throw WebdavProtocolException.generalError(x, this.url, 500);
        }
    }

    @Override
    public void setDisplayName(String displayName) throws WebdavProtocolException {
    }

    @Override
    public void unlock(String token) throws WebdavProtocolException {
        this.lockHelper.removeLock(token);
    }

    public void setId(int id) {
        this.id = id;
        this.propertyHelper.setId(id);
        this.lockHelper.setId(id);
    }

    public void setExists(boolean b) {
        this.exists = b;
    }

    private void loadFolder() throws WebdavProtocolException {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (!this.exists) {
            this.folder = new FolderObject();
            return;
        }
        Connection readCon = null;
        Context ctx = this.getSession().getContext();
        try {
            readCon = this.provider.getReadConnection(ctx);
            this.folder = FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(this.id, false, ctx, readCon) : FolderObject.loadFolderObjectFromDB(this.id, ctx, readCon);
        }
        catch (Exception e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
        finally {
            this.provider.releaseReadConnection(ctx, readCon);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpToDB() throws WebdavProtocolException {
        if (this.exists) {
            if (this.folder == null) {
                return;
            }
            this.folder.setLastModified(new Date());
            this.folder.setModifiedBy(this.getSession().getUserId());
            this.initParent(this.folder);
            ServerSession session = this.getSession();
            Context ctx = session.getContext();
            Connection writeCon = null;
            try {
                writeCon = this.provider.getWriteConnection(ctx);
                OXFolderManager oxma = OXFolderManager.getInstance(this.getSession(), writeCon, writeCon);
                oxma.updateFolder(this.folder, true, false, System.currentTimeMillis());
                return;
            }
            catch (OXException x) {
                if (!this.isPermissionException(x)) throw WebdavProtocolException.generalError(x, this.url, 500);
                throw WebdavProtocolException.generalError(x, this.url, 403);
            }
            catch (Exception e) {
                throw WebdavProtocolException.generalError(e, this.url, 500);
            }
            finally {
                this.provider.releaseWriteConnection(ctx, writeCon);
            }
        }
        if (this.folder == null) {
            this.folder = new FolderObject();
        }
        Context ctx = null;
        Connection writeCon = null;
        try {
            this.initDefaultAcl(this.folder);
            this.initDefaultFields(this.folder);
            ServerSession session = this.getSession();
            ctx = session.getContext();
            writeCon = this.provider.getWriteConnection(ctx);
            OXFolderManager oxma = OXFolderManager.getInstance(this.getSession(), writeCon, writeCon);
            this.folder = oxma.createFolder(this.folder, true, System.currentTimeMillis());
            this.setId(this.folder.getObjectID());
            this.provider.releaseWriteConnection(ctx, writeCon);
            return;
        }
        catch (WebdavProtocolException x) {
            try {
                throw x;
                catch (OXException x2) {
                    if (!this.isPermissionException(x2)) throw WebdavProtocolException.generalError(x2, this.url, 500);
                    throw WebdavProtocolException.generalError(x2, this.url, 403);
                }
                catch (Exception e) {
                    throw WebdavProtocolException.generalError(e, this.url, 500);
                }
            }
            catch (Throwable throwable) {
                this.provider.releaseWriteConnection(ctx, writeCon);
                throw throwable;
            }
        }
    }

    private boolean isPermissionException(OXException x) {
        return Category.CATEGORY_PERMISSION_DENIED.equals(x.getCategory());
    }

    private void initDefaultFields(FolderObject folder) throws WebdavProtocolException {
        this.initParent(folder);
        folder.setType(2);
        folder.setModule(8);
        if (folder.getFolderName() == null || folder.getFolderName().length() == 0) {
            folder.setFolderName(this.url.name());
        }
        folder.removeObjectID();
    }

    private void initParent(FolderObject folder) throws WebdavProtocolException {
        try {
            FolderCollection parent = (FolderCollection)this.parent();
            if (!parent.exists()) {
                throw WebdavProtocolException.generalError(this.getUrl(), 409);
            }
            folder.setParentFolderID(parent.id);
        }
        catch (ClassCastException x) {
            throw WebdavProtocolException.generalError(this.getUrl(), 409);
        }
    }

    private void initDefaultAcl(FolderObject folder) throws OXException {
        List<OCLPermission> copyPerms;
        if (this.overrideNewACL == null) {
            FolderCollection parent = (FolderCollection)this.parent();
            parent.loadFolder();
            FolderObject parentFolder = parent.folder;
            copyPerms = 5 == parentFolder.getType() ? Collections.emptyList() : parentFolder.getPermissions();
        } else {
            copyPerms = this.overrideNewACL;
        }
        ArrayList<OCLPermission> newPerms = new ArrayList<OCLPermission>();
        User owner = UserStorage.getInstance().getUser(this.getSession().getUserId(), this.getSession().getContext());
        for (OCLPermission perm : copyPerms) {
            if (perm.getEntity() == owner.getId()) continue;
            newPerms.add(perm.deepClone());
        }
        OCLPermission perm = new OCLPermission();
        perm.setEntity(owner.getId());
        perm.setFolderAdmin(true);
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(4);
        perm.setWriteObjectPermission(4);
        perm.setDeleteObjectPermission(4);
        perm.setGroupPermission(false);
        newPerms.add(perm);
        folder.setPermissions(newPerms);
    }

    private void loadChildren() throws WebdavProtocolException {
        if (this.loadedChildren || !this.exists) {
            return;
        }
        this.loadedChildren = true;
        SearchIterator<FolderObject> iter = null;
        try {
            if (this.folder == null) {
                this.loadFolder();
            }
            ServerSession session = this.getSession();
            User user = UserStorage.getInstance().getUser(session.getUserId(), session.getContext());
            UserPermissionBits userPermissionBits = UserPermissionBitsStorage.getInstance().getUserPermissionBits(session.getUserId(), session.getContext());
            Context ctx = session.getContext();
            iter = OXFolderIteratorSQL.getVisibleSubfoldersIterator(this.id, user.getId(), user.getGroups(), ctx, userPermissionBits, new Timestamp(0L));
            while (iter.hasNext()) {
                FolderObject folder = (FolderObject)iter.next();
                if (16 == folder.getType()) continue;
                WebdavPath newUrl = this.getUrl().dup().append(this.getFolderName(folder));
                this.children.add(new FolderCollection(newUrl, this.factory, folder));
            }
            this.children.addAll(this.factory.getResourcesInFolder(this, this.folder.getObjectID()));
        }
        catch (WebdavProtocolException e) {
            throw e;
        }
        catch (Exception e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
        finally {
            SearchIterators.close(iter);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void initUrl() {
        if (this.id == 9) {
            this.url = new WebdavPath(new String[0]);
            return;
        }
        try {
            this.url = this.parent().getUrl().dup().append(this.getDisplayName());
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public void registerChild(OXWebdavResource resource) {
        this.children.add(resource);
    }

    public void unregisterChild(OXWebdavResource resource) {
        this.children.remove(resource);
    }

    @Override
    public int getParentId() throws WebdavProtocolException {
        if (this.exists) {
            this.loadFolder();
            return this.folder.getParentFolderID();
        }
        WebdavPath url = this.getUrl();
        return ((OXWebdavResource)((Object)this.factory.resolveCollection(url.parent()))).getId();
    }

    @Override
    public void removedParent() throws WebdavProtocolException {
        this.exists = false;
        this.factory.removed(this);
        for (OXWebdavResource res : this.children) {
            res.removedParent();
        }
    }

    @Override
    public void transferLock(WebdavLock lock) throws WebdavProtocolException {
        try {
            this.lockHelper.transferLock(lock);
        }
        catch (OXException e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " :" + this.id;
    }

    public String getFolderName(FolderObject folder) {
        String alias;
        if (this.aliases != null && (alias = this.aliases.getAlias(folder.getObjectID())) != null) {
            return alias;
        }
        return folder.getFolderName();
    }

    public EffectivePermission getEffectivePermission() throws WebdavProtocolException {
        this.loadFolder();
        ServerSession session = this.getSession();
        UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext());
        Context ctx = session.getContext();
        Connection con = null;
        try {
            con = this.provider.getReadConnection(ctx);
            EffectivePermission effectivePermission = this.folder.getEffectiveUserPermission(session.getUserId(), userConfig, con);
            return effectivePermission;
        }
        catch (Exception e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
        finally {
            if (con != null) {
                this.provider.releaseReadConnection(ctx, con);
            }
        }
    }

    public boolean isRoot() {
        return this.id == 9;
    }

    private ServerSession getSession() {
        return ServerSessionAdapter.valueOf(this.sessionHolder.getSessionObject(), this.sessionHolder.getContext());
    }
}

