/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.index;

import com.openexchange.groupware.attach.index.Attachment;

public class AttachmentUUID {
    private final String uuid;

    private AttachmentUUID(int contextId, int userId, int module, String account, String folder, String objectId, String attachmentId) {
        StringBuilder tmp = new StringBuilder(64);
        tmp.append("attachments/");
        tmp.append(contextId).append('/');
        tmp.append(userId).append('/');
        tmp.append(module).append('/');
        tmp.append(account).append('/');
        tmp.append(folder).append('/').append(objectId).append('/').append(attachmentId);
        this.uuid = tmp.toString();
    }

    public static AttachmentUUID newUUID(int contextId, int userId, int module, String account, String folder, String objectId, String attachmentId) {
        return new AttachmentUUID(contextId, userId, module, account, folder, objectId, attachmentId);
    }

    public static AttachmentUUID newUUID(int contextId, int userId, Attachment attachment) {
        return new AttachmentUUID(contextId, userId, attachment.getModule(), attachment.getAccount(), attachment.getFolder(), attachment.getObjectId(), attachment.getAttachmentId());
    }

    public String toString() {
        return this.uuid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentUUID other = (AttachmentUUID)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

