/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.ContactServiceInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContactServiceInterceptorRegistry
implements ServiceTrackerCustomizer<ContactServiceInterceptor, ContactServiceInterceptor> {
    private final List<ContactServiceInterceptor> interceptors;
    private final Comparator<ContactServiceInterceptor> comparator;
    private final BundleContext context;

    public ContactServiceInterceptorRegistry(BundleContext context) {
        this.context = context;
        this.interceptors = new LinkedList<ContactServiceInterceptor>();
        this.comparator = new Comparator<ContactServiceInterceptor>(){

            @Override
            public int compare(ContactServiceInterceptor s1, ContactServiceInterceptor s2) {
                return s2.getRanking() - s1.getRanking();
            }
        };
    }

    public ContactServiceInterceptor addingService(ServiceReference<ContactServiceInterceptor> reference) {
        ContactServiceInterceptor service = (ContactServiceInterceptor)this.context.getService(reference);
        this.addInterceptor(service);
        return service;
    }

    public void modifiedService(ServiceReference<ContactServiceInterceptor> reference, ContactServiceInterceptor service) {
    }

    public void removedService(ServiceReference<ContactServiceInterceptor> reference, ContactServiceInterceptor service) {
        this.removeInterceptor(service);
        this.context.ungetService(reference);
    }

    public synchronized List<ContactServiceInterceptor> getInterceptors() {
        return new ArrayList<ContactServiceInterceptor>(this.interceptors);
    }

    synchronized void addInterceptor(ContactServiceInterceptor interceptor) {
        this.interceptors.add(interceptor);
        Collections.sort(this.interceptors, this.comparator);
    }

    synchronized void removeInterceptor(ContactServiceInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }
}

