/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.config.json.ConfigAJAXRequest;
import com.openexchange.config.json.actions.AbstractConfigAction;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="get_property", description="Gets a user property", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="name", description="The property name.")}, responseDescription="A JSON object providing the property's name and its value")
public class GetPropertyAction
extends AbstractConfigAction {
    public GetPropertyAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ConfigAJAXRequest req) throws OXException, JSONException {
        ConfigViewFactory factory = this.getService(ConfigViewFactory.class);
        if (null == factory) {
            throw ServiceExceptionCode.absentService(ConfigViewFactory.class);
        }
        String propertyName = req.checkParameter("name");
        if (Strings.isEmpty((String)propertyName)) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("name", propertyName);
        }
        ServerSession session = req.getSession();
        ConfigView view = factory.getView(session.getUserId(), session.getContextId());
        ConfigProperty property = view.property("context", propertyName, String.class);
        if (!property.isDefined()) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(propertyName);
        }
        if (Boolean.parseBoolean(property.get("protected"))) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(propertyName);
        }
        ComposedConfigProperty composedProperty = view.property(propertyName, String.class);
        return new AJAXRequestResult(new JSONObject(2).put("name", (Object)propertyName).put("value", composedProperty.get()));
    }
}

