/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.ajax.requesthandler.cache.AbstractResourceCache;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadata;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.server.ServiceLookup;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;

public class RdbResourceCacheImpl
extends AbstractResourceCache {
    public RdbResourceCacheImpl(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public boolean save(String id, CachedResource resource, int userId, int contextId) throws OXException {
        InputStream in = resource.getInputStream();
        if (null == in) {
            return this.save(id, resource.getBytes(), resource.getFileName(), resource.getFileType(), userId, contextId);
        }
        return this.save(id, in, resource.getFileName(), resource.getFileType(), userId, contextId);
    }

    private boolean save(String id, InputStream in, String optName, String optType, int userId, int contextId) throws OXException {
        try {
            return this.save(id, Streams.stream2bytes((InputStream)in), optName, optType, userId, contextId);
        }
        catch (IOException e) {
            throw PreviewExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(String id, byte[] bytes, String optName, String optType, int userId, int contextId) throws OXException {
        boolean bl;
        PreparedStatement stmt;
        DatabaseService dbService;
        Connection con;
        block13: {
            long existingSize;
            ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
            ResourceCacheMetadata existingMetadata = RdbResourceCacheImpl.loadExistingEntry(metadataStore, con = (dbService = this.getDBService()).getWritable(contextId), contextId, userId, id);
            long l = existingSize = existingMetadata == null ? 0L : existingMetadata.getSize();
            if (!this.ensureUnexceededContextQuota(con, bytes.length, contextId, existingSize)) {
                dbService.backWritable(contextId, con);
                return false;
            }
            boolean committed = false;
            stmt = null;
            try {
                int pos;
                Databases.startTransaction((Connection)con);
                ResourceCacheMetadata metadata = new ResourceCacheMetadata();
                metadata.setContextId(contextId);
                metadata.setUserId(userId);
                metadata.setResourceId(id);
                metadata.setFileName(optName);
                metadata.setFileType(this.prepareFileName(optName));
                metadata.setSize(bytes.length);
                metadata.setCreatedAt(System.currentTimeMillis());
                if (existingMetadata == null) {
                    metadataStore.store(con, metadata);
                    pos = 1;
                    stmt = con.prepareStatement("INSERT INTO previewData (cid, user, id, data) VALUES (?, ?, ?, ?)");
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                    stmt.setBinaryStream(pos++, Streams.newByteArrayInputStream((byte[])bytes));
                    stmt.executeUpdate();
                } else {
                    metadataStore.update(con, metadata);
                    pos = 1;
                    stmt = con.prepareStatement("UPDATE previewData SET data = ? WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setBinaryStream(pos++, Streams.newByteArrayInputStream((byte[])bytes));
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                    stmt.executeUpdate();
                }
                con.commit();
                committed = true;
                bl = true;
                if (committed) break block13;
            }
            catch (DataTruncation e) {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                catch (SQLIntegrityConstraintViolationException e2) {
                    boolean bl2 = false;
                    return bl2;
                }
                catch (SQLException e3) {
                    block14: {
                        if (e3.getErrorCode() != 1022) break block14;
                        boolean bl3 = false;
                        return bl3;
                    }
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e3, new Object[]{e3.getMessage()});
                }
            }
            finally {
                if (!committed) {
                    Databases.rollback((Connection)con);
                }
                Databases.closeSQLStuff(stmt);
                Databases.autocommit((Connection)con);
                dbService.backWritable(contextId, con);
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((Statement)stmt);
        Databases.autocommit((Connection)con);
        dbService.backWritable(contextId, con);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ensureUnexceededContextQuota(Connection con, long desiredSize, int contextId, long existingSize) throws OXException {
        boolean bl;
        PreparedStatement stmt;
        boolean commited;
        block13: {
            block14: {
                ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
                long total = this.getGlobalQuota();
                long totalPerDocument = this.getDocumentQuota();
                if (total <= 0L) {
                    if (totalPerDocument <= 0L) return true;
                }
                if (total <= 0L) {
                    if (totalPerDocument <= 0L) return true;
                    if (desiredSize <= totalPerDocument) return true;
                    return false;
                }
                if (desiredSize > total) return false;
                if (desiredSize > totalPerDocument) {
                    return false;
                }
                commited = false;
                stmt = null;
                try {
                    Databases.startTransaction((Connection)con);
                    long usedContextQuota = metadataStore.getUsedSize(con, contextId) - existingSize;
                    while (usedContextQuota + desiredSize > total) {
                        ResourceCacheMetadata metadata = metadataStore.removeOldest(con, contextId);
                        if (metadata == null) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND user=? AND id=?");
                        stmt.setInt(1, contextId);
                        stmt.setInt(2, metadata.getUserId());
                        stmt.setString(3, metadata.getResourceId());
                        stmt.executeUpdate();
                        usedContextQuota = metadataStore.getUsedSize(con, contextId) - existingSize;
                        if (usedContextQuota > 0L || desiredSize <= total) continue;
                        bl = false;
                        Databases.closeSQLStuff((Statement)stmt);
                        if (commited) break block13;
                        break block14;
                    }
                    con.commit();
                    commited = true;
                    return true;
                }
                catch (SQLException e) {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.autocommit((Connection)con);
        return bl;
        finally {
            Databases.closeSQLStuff(stmt);
            if (!commited) {
                Databases.rollback((Connection)con);
            }
            Databases.autocommit((Connection)con);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CachedResource get(String id, int userId, int contextId) throws OXException {
        CachedResource cachedResource;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        DatabaseService dbService;
        block14: {
            CachedResource cachedResource2;
            block13: {
                if (null == id) return null;
                if (contextId <= 0) {
                    return null;
                }
                dbService = this.getDBService();
                ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
                con = dbService.getReadOnly(contextId);
                stmt = null;
                rs = null;
                try {
                    ResourceCacheMetadata metadata = metadataStore.load(con, contextId, userId, id);
                    if (metadata == null) {
                        CachedResource cachedResource3 = null;
                        return cachedResource3;
                    }
                    if (userId > 0) {
                        stmt = con.prepareStatement("SELECT data FROM previewData WHERE cid = ? AND user = ? AND id = ?");
                        stmt.setLong(1, contextId);
                        stmt.setLong(2, userId);
                        stmt.setString(3, id);
                    } else {
                        stmt = con.prepareStatement("SELECT data FROM previewData WHERE cid = ? AND id = ?");
                        stmt.setLong(1, contextId);
                        stmt.setString(2, id);
                    }
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        cachedResource2 = null;
                        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                        break block13;
                    }
                    cachedResource = new CachedResource(Streams.stream2bytes((InputStream)rs.getBinaryStream(1)), metadata.getFileName(), metadata.getFileType(), metadata.getSize());
                    Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                    break block14;
                }
                catch (SQLException e) {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (IOException e) {
                    throw PreviewExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
            dbService.backReadOnly(contextId, con);
            return cachedResource2;
        }
        dbService.backReadOnly(contextId, con);
        return cachedResource;
        finally {
            Databases.closeSQLStuff(rs, stmt);
            dbService.backReadOnly(contextId, con);
        }
    }

    @Override
    public void remove(int userId, int contextId) throws OXException {
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        PreparedStatement stmt = null;
        boolean committed = false;
        try {
            Databases.startTransaction((Connection)con);
            List<ResourceCacheMetadata> removed = metadataStore.removeAll(con, contextId, -1);
            if (!removed.isEmpty()) {
                stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND user=? AND id=?");
                for (ResourceCacheMetadata metadata : removed) {
                    stmt.setInt(1, contextId);
                    stmt.setInt(2, userId);
                    stmt.setString(3, metadata.getResourceId());
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            con.commit();
            committed = true;
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(stmt);
                if (!committed) {
                    Databases.rollback((Connection)con);
                }
                Databases.autocommit((Connection)con);
                dbService.backWritable(contextId, con);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((Statement)stmt);
        if (!committed) {
            Databases.rollback((Connection)con);
        }
        Databases.autocommit((Connection)con);
        dbService.backWritable(contextId, con);
    }

    @Override
    public void removeAlikes(String id, int userId, int contextId) throws OXException {
        if (null == id) {
            throw PreviewExceptionCodes.ERROR.create(new Object[]{"Missing identifier."});
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        boolean committed = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Databases.startTransaction((Connection)con);
            List<ResourceCacheMetadata> removed = metadataStore.removeAll(con, contextId, userId, id);
            if (!removed.isEmpty()) {
                HashSet<String> ids = new HashSet<String>(16);
                for (ResourceCacheMetadata metadata : removed) {
                    ids.add(metadata.getResourceId());
                }
                stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND user=? AND id=?");
                int pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                for (String ide : ids) {
                    stmt.setString(pos, ide);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            con.commit();
            committed = true;
        }
        catch (DataTruncation e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (!committed) {
                Databases.rollback((Connection)con);
            }
            Databases.closeSQLStuff(rs, stmt);
            Databases.autocommit((Connection)con);
            dbService.backWritable(contextId, con);
        }
    }

    @Override
    public void clearFor(int contextId) throws OXException {
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        PreparedStatement stmt = null;
        boolean committed = false;
        try {
            Databases.startTransaction((Connection)con);
            List<ResourceCacheMetadata> removed = metadataStore.removeAll(con, contextId, -1);
            if (!removed.isEmpty()) {
                stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND id=?");
                for (ResourceCacheMetadata metadata : removed) {
                    stmt.setInt(1, contextId);
                    stmt.setString(2, metadata.getResourceId());
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            con.commit();
            committed = true;
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(stmt);
                if (!committed) {
                    Databases.rollback((Connection)con);
                }
                Databases.autocommit((Connection)con);
                dbService.backWritable(contextId, con);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((Statement)stmt);
        if (!committed) {
            Databases.rollback((Connection)con);
        }
        Databases.autocommit((Connection)con);
        dbService.backWritable(contextId, con);
    }

    @Override
    public boolean exists(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return false;
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        ResourceCacheMetadata metadata = metadataStore.load(contextId, userId, id);
        return metadata != null;
    }
}

