/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.DispatcherResult;
import com.openexchange.ajax.requesthandler.DispatcherServlet;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.LastModifiedAwareAJAXActionService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.tools.session.ServerSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Dispatchers {
    private Dispatchers() {
    }

    public static DispatcherResult perform(AJAXRequestData requestData, Dispatcher dispatcher, ServerSession session) throws OXException {
        AJAXState ajaxState = dispatcher.begin();
        return new DispatcherResult(requestData, dispatcher.perform(requestData, ajaxState, session), ajaxState, dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendResponse(DispatcherResult result, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            DispatcherServlet.sendResponse(result.getRequestData(), result.getRequestResult(), httpRequest, httpResponse);
        }
        finally {
            result.close();
        }
    }

    public static String getActionFrom(HttpServletRequest req) {
        String action = req.getParameter("action");
        return null == action ? Strings.toUpperCase((CharSequence)req.getMethod()) : action;
    }

    public static boolean isApiOutputExpectedFor(HttpServletRequest req) {
        String prefix = Dispatchers.getPrefix();
        if (req.getRequestURI().startsWith(prefix)) {
            AJAXRequestDataTools requestDataTools = AJAXRequestDataTools.getInstance();
            String module = requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
            AJAXActionServiceFactory factory = DispatcherServlet.getDispatcher().lookupFactory(module);
            if (factory != null) {
                return Dispatchers.isApiOutputExpectedFor(Dispatchers.optActionFor(requestDataTools.getAction(req), factory));
            }
        }
        return true;
    }

    public static String getPrefix() {
        String prefix = DispatcherServlet.getPrefix();
        return prefix == null ? "/ajax/" : prefix;
    }

    private static AJAXActionService optActionFor(String sAction, AJAXActionServiceFactory factory) {
        try {
            return factory.createActionService(sAction);
        }
        catch (OXException e) {
            return null;
        }
    }

    public static boolean isApiOutputExpectedFor(AJAXActionService action) {
        if (null == action) {
            return true;
        }
        if (action instanceof ETagAwareAJAXActionService || action instanceof LastModifiedAwareAJAXActionService) {
            return false;
        }
        DispatcherNotes dispatcherNotes = action.getClass().getAnnotation(DispatcherNotes.class);
        return null == dispatcherNotes || !"file".equals(dispatcherNotes.defaultFormat());
    }
}

