/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizerFactory;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.AJAXStateHandler;
import com.openexchange.ajax.requesthandler.CombinedActionFactory;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.FlowControl;
import com.openexchange.ajax.requesthandler.LastModifiedAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.Module;
import com.openexchange.continuation.Continuation;
import com.openexchange.continuation.ContinuationException;
import com.openexchange.continuation.ContinuationExceptionCodes;
import com.openexchange.continuation.ContinuationRegistryService;
import com.openexchange.continuation.ContinuationResponse;
import com.openexchange.exception.OXException;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import com.openexchange.log.LogProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDispatcher
implements Dispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDispatcher.class);
    private final ConcurrentMap<StrPair, Boolean> fallbackSessionActionsCache = new ConcurrentHashMap<StrPair, Boolean>(128);
    private final ConcurrentMap<StrPair, Boolean> publicSessionAuthCache = new ConcurrentHashMap<StrPair, Boolean>(128);
    private final ConcurrentMap<StrPair, Boolean> omitSessionActionsCache = new ConcurrentHashMap<StrPair, Boolean>(128);
    private final ConcurrentMap<StrPair, Boolean> noSecretCallbackCache = new ConcurrentHashMap<StrPair, Boolean>(128);
    private final ConcurrentMap<String, AJAXActionServiceFactory> actionFactories = new ConcurrentHashMap<String, AJAXActionServiceFactory>();
    private final Queue<AJAXActionCustomizerFactory> customizerFactories = new Java7ConcurrentLinkedQueue();

    @Override
    public AJAXState begin() throws OXException {
        return new AJAXState();
    }

    @Override
    public void end(AJAXState state) {
        if (null != state) {
            state.close();
        }
    }

    @Override
    public boolean handles(String module) {
        return this.actionFactories.containsKey(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, AJAXState state, ServerSession session) throws OXException {
        if (null == session) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
        }
        this.addLogProperties(requestData, false);
        try {
            AJAXRequestResult result;
            long ifUnmodifiedSince;
            long lastModified;
            AJAXActionCustomizer customizer;
            AbstractList outgoing = new ArrayList<AJAXActionCustomizer>(this.customizerFactories.size());
            LinkedList<AJAXActionCustomizer> todo = new LinkedList<AJAXActionCustomizer>();
            for (AJAXActionCustomizerFactory customizerFactory : this.customizerFactories) {
                customizer = customizerFactory.createCustomizer(requestData, session);
                if (customizer == null) continue;
                todo.add(customizer);
            }
            AJAXRequestData modifiedRequestData = requestData;
            while (!todo.isEmpty()) {
                Iterator iterator = todo.iterator();
                while (iterator.hasNext()) {
                    customizer = (AJAXActionCustomizer)iterator.next();
                    try {
                        AJAXRequestData modified = customizer.incoming(modifiedRequestData, session);
                        if (modified != null) {
                            modifiedRequestData = modified;
                        }
                        outgoing.add(customizer);
                        iterator.remove();
                    }
                    catch (FlowControl.Later l) {}
                }
            }
            AJAXActionServiceFactory factory = this.lookupFactory(modifiedRequestData.getModule());
            if (factory == null) {
                throw AjaxExceptionCodes.UNKNOWN_MODULE.create(modifiedRequestData.getModule());
            }
            AJAXActionService action = factory.createActionService(modifiedRequestData.getAction());
            if (action == null) {
                throw AjaxExceptionCodes.UNKNOWN_ACTION_IN_MODULE.create(modifiedRequestData.getAction(), modifiedRequestData.getModule());
            }
            String eTag = modifiedRequestData.getETag();
            if (null != eTag && action instanceof ETagAwareAJAXActionService && ("*".equals(eTag) || ((ETagAwareAJAXActionService)action).checkETag(eTag, modifiedRequestData, session))) {
                AJAXRequestResult etagResult = new AJAXRequestResult();
                etagResult.setType(AJAXRequestResult.ResultType.ETAG);
                long newExpires = modifiedRequestData.getExpires();
                if (newExpires > 0L) {
                    etagResult.setExpires(newExpires);
                }
                return etagResult;
            }
            if (null == eTag && action instanceof LastModifiedAwareAJAXActionService && (lastModified = modifiedRequestData.getLastModified()) >= 0L && ((LastModifiedAwareAJAXActionService)action).checkLastModified(lastModified + 1000L, modifiedRequestData, session)) {
                AJAXRequestResult etagResult = new AJAXRequestResult();
                etagResult.setType(AJAXRequestResult.ResultType.ETAG);
                long newExpires = modifiedRequestData.getExpires();
                if (newExpires > 0L) {
                    etagResult.setExpires(newExpires);
                }
                return etagResult;
            }
            String ifMatch = modifiedRequestData.getHeader("If-Match");
            if (ifMatch != null && action instanceof ETagAwareAJAXActionService && ("*".equals(ifMatch) || ((ETagAwareAJAXActionService)action).checkETag(ifMatch, modifiedRequestData, session))) {
                AJAXRequestResult failedResult = new AJAXRequestResult();
                failedResult.setHttpStatusCode(412);
                return failedResult;
            }
            if (action instanceof LastModifiedAwareAJAXActionService && (ifUnmodifiedSince = Tools.optHeaderDate(modifiedRequestData.getHeader("If-Unmodified-Since"))) >= 0L && ((LastModifiedAwareAJAXActionService)action).checkLastModified(ifUnmodifiedSince + 1000L, modifiedRequestData, session)) {
                AJAXRequestResult failedResult = new AJAXRequestResult();
                failedResult.setHttpStatusCode(412);
                return failedResult;
            }
            if (modifiedRequestData.getFormat() == null) {
                DispatcherNotes actionMetadata = this.getActionMetadata(action);
                modifiedRequestData.setFormat(actionMetadata == null ? "apiResponse" : actionMetadata.defaultFormat());
            }
            if (factory instanceof AJAXStateHandler) {
                AJAXStateHandler handler = (AJAXStateHandler)((Object)factory);
                if (state.addInitializer(modifiedRequestData.getModule(), handler)) {
                    handler.initialize(state);
                }
            }
            modifiedRequestData.setState(state);
            try {
                result = action.perform(modifiedRequestData, session);
                if (null == result) {
                    this.addLogProperties(modifiedRequestData, true);
                    throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(AJAXRequestResult.class.getSimpleName(), "null");
                }
            }
            catch (IllegalStateException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OXException) {
                    throw (OXException)cause;
                }
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            catch (ContinuationException e) {
                result = this.handleContinuationException(e, session);
            }
            finally {
                modifiedRequestData.cleanUploads();
            }
            if (AJAXRequestResult.ResultType.DIRECT == result.getType()) {
                return result;
            }
            Collections.reverse(outgoing);
            outgoing = new LinkedList(outgoing);
            while (!outgoing.isEmpty()) {
                Iterator iterator = outgoing.iterator();
                while (iterator.hasNext()) {
                    AJAXActionCustomizer customizer2 = (AJAXActionCustomizer)iterator.next();
                    try {
                        AJAXRequestResult modified = customizer2.outgoing(modifiedRequestData, result, session);
                        if (modified != null && AJAXRequestResult.ResultType.DIRECT == (result = modified).getType()) {
                            return result;
                        }
                        iterator.remove();
                    }
                    catch (FlowControl.Later l) {}
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            Throwable wrapped;
            if ("org.mozilla.javascript.WrappedException".equals(e.getClass().getName()) && (wrapped = e.getCause()) instanceof OXException) {
                throw (OXException)wrapped;
            }
            this.addLogProperties(requestData, true);
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private AJAXRequestResult handleContinuationException(ContinuationException e, ServerSession session) throws OXException {
        if (!ContinuationExceptionCodes.SCHEDULED_FOR_CONTINUATION.equals((OXException)((Object)e))) {
            throw e;
        }
        UUID uuid = e.getUuid();
        if (null == uuid) {
            throw e;
        }
        ContinuationRegistryService continuationRegistry = ServerServiceRegistry.getInstance().getService(ContinuationRegistryService.class);
        if (null == continuationRegistry) {
            throw e;
        }
        Continuation continuation = continuationRegistry.getContinuation(uuid, (Session)session);
        if (null == continuation) {
            throw e;
        }
        try {
            ContinuationResponse cr = continuation.getNextResponse(1000L, TimeUnit.NANOSECONDS);
            return new AJAXRequestResult(cr.getValue(), cr.getTimeStamp(), cr.getFormat()).setContinuationUuid(cr.isCompleted() ? null : uuid);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(ie, ie.getMessage());
        }
    }

    private void addLogProperties(AJAXRequestData requestData, boolean withQueryString) {
        if (null != requestData) {
            Map<String, String> parameters;
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.AJAX_ACTION, (Object)requestData.getAction());
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.AJAX_MODULE, (Object)requestData.getModule());
            if (withQueryString && null != (parameters = requestData.getParameters())) {
                StringBuilder sb = new StringBuilder(256);
                sb.append('\"');
                boolean first = true;
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    if (first) {
                        sb.append('?');
                        first = false;
                    } else {
                        sb.append('&');
                    }
                    String value = LogProperties.getSanitizedValue((String)entry.getKey(), (String)entry.getValue());
                    sb.append(entry.getKey()).append('=').append(value);
                }
                sb.append('\"');
                LogProperties.putProperty((LogProperties.Name)LogProperties.Name.SERVLET_QUERY_STRING, (Object)sb.toString());
            }
        }
    }

    @Override
    public AJAXActionServiceFactory lookupFactory(String module) {
        int pos;
        AJAXActionServiceFactory serviceFactory = (AJAXActionServiceFactory)this.actionFactories.get(module);
        if (null == serviceFactory && (pos = module.indexOf(47)) > 0) {
            serviceFactory = (AJAXActionServiceFactory)this.actionFactories.get(module.substring(0, pos));
        }
        return serviceFactory;
    }

    private DispatcherNotes getActionMetadata(AJAXActionService action) {
        if (null == action) {
            return null;
        }
        return action.getClass().getAnnotation(DispatcherNotes.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String module, AJAXActionServiceFactory factory) {
        ConcurrentMap<String, AJAXActionServiceFactory> concurrentMap = this.actionFactories;
        synchronized (concurrentMap) {
            AJAXActionServiceFactory current = this.actionFactories.putIfAbsent(module, factory);
            if (null != current) {
                try {
                    current = (AJAXActionServiceFactory)this.actionFactories.get(module);
                    Module moduleAnnotation = current.getClass().getAnnotation(Module.class);
                    if (null == moduleAnnotation) {
                        StringBuilder sb = new StringBuilder(512).append("There is already a factory associated with module \"");
                        sb.append(module).append("\": ").append(current.getClass().getName());
                        sb.append(". Therefore registration is denied for factory \"").append(factory.getClass().getName());
                        sb.append("\". Unless these two factories provide the \"").append(Module.class.getName()).append("\" annotation to specify what actions are supported by each factory.");
                        LOG.warn(sb.toString());
                    } else {
                        CombinedActionFactory combinedFactory;
                        if (current instanceof CombinedActionFactory) {
                            combinedFactory = (CombinedActionFactory)current;
                        } else {
                            combinedFactory = new CombinedActionFactory();
                            combinedFactory.add(current);
                            this.actionFactories.put(module, combinedFactory);
                        }
                        combinedFactory.add(factory);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    public void addCustomizer(AJAXActionCustomizerFactory factory) {
        this.customizerFactories.add(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String module, AJAXActionServiceFactory factory) {
        ConcurrentMap<String, AJAXActionServiceFactory> concurrentMap = this.actionFactories;
        synchronized (concurrentMap) {
            AJAXActionServiceFactory removed = (AJAXActionServiceFactory)this.actionFactories.remove(module);
            if (removed instanceof CombinedActionFactory) {
                CombinedActionFactory combinedFactory = (CombinedActionFactory)removed;
                combinedFactory.remove(factory);
                if (!combinedFactory.isEmpty()) {
                    this.actionFactories.put(module, combinedFactory);
                }
            }
        }
    }

    private AJAXActionService getActionServiceSafe(String action, AJAXActionServiceFactory factory) {
        try {
            return factory.createActionService(action);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean mayUseFallbackSession(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.fallbackSessionActionsCache.get(key);
        if (null == ret) {
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            if (factory == null) {
                return false;
            }
            DispatcherNotes actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory));
            ret = actionMetadata == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.allowPublicSession());
            this.fallbackSessionActionsCache.put(key, ret);
        }
        return ret;
    }

    @Override
    public boolean mayPerformPublicSessionAuth(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.publicSessionAuthCache.get(key);
        if (null == ret) {
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            if (factory == null) {
                return false;
            }
            DispatcherNotes actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory));
            ret = actionMetadata == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.publicSessionAuth());
            this.publicSessionAuthCache.put(key, ret);
        }
        return ret;
    }

    @Override
    public boolean mayOmitSession(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.omitSessionActionsCache.get(key);
        if (null == ret) {
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            if (factory == null) {
                return false;
            }
            DispatcherNotes actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory));
            ret = actionMetadata == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.noSession());
            this.omitSessionActionsCache.put(key, ret);
        }
        return ret;
    }

    @Override
    public boolean noSecretCallback(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.noSecretCallbackCache.get(key);
        if (null == ret) {
            DispatcherNotes actionMetadata;
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            ret = factory == null ? Boolean.FALSE : ((actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory))) == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.noSecretCallback()));
            this.noSecretCallbackCache.put(key, ret);
        }
        return ret;
    }

    private static final class StrPair {
        private final String str1;
        private final String str2;
        private final int hash;

        StrPair(String str1, String str2) {
            this.str1 = str1;
            this.str2 = str2;
            int prime = 31;
            int result = 1;
            result = 31 * result + (str1 == null ? 0 : str1.hashCode());
            this.hash = result = 31 * result + (str2 == null ? 0 : str2.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StrPair)) {
                return false;
            }
            StrPair other = (StrPair)obj;
            if (this.str1 == null ? other.str1 != null : !this.str1.equals(other.str1)) {
                return false;
            }
            return !(this.str2 == null ? other.str2 != null : !this.str2.equals(other.str2));
        }
    }
}

