/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.login.AbstractLoginRequestHandler;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginClosure;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.server.services.SessionInspector;
import com.openexchange.session.Reply;
import com.openexchange.session.Session;
import com.openexchange.session.inspector.Reason;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLogin
extends AbstractLoginRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AutoLogin.class);
    private final LoginConfiguration conf;

    public AutoLogin(LoginConfiguration conf, Set<LoginRampUpService> rampUp) {
        super(rampUp);
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        Session session = null;
        try {
            SessiondService sessiondService;
            if (!this.conf.isSessiondAutoLogin()) {
                if (this.doAutoLogin(req, resp)) {
                    if (Reply.STOP == SessionInspector.getInstance().getChain().onAutoLoginFailed(Reason.AUTO_LOGIN_DISABLED, req, resp)) {
                        return;
                    }
                    throw AjaxExceptionCodes.DISABLED_ACTION.create("autologin");
                }
                return;
            }
            javax.servlet.http.Cookie[] cookies = req.getCookies();
            if (cookies == null) {
                cookies = new javax.servlet.http.Cookie[]{};
            }
            if (null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
                OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                LOG.error("", (Throwable)se);
                resp.sendError(403);
                return;
            }
            String secret = null;
            String hash = HashCalculator.getInstance().getHash(req);
            String sessionCookieName = LoginServlet.SESSION_PREFIX + hash;
            String secretCookieName = LoginServlet.SECRET_PREFIX + hash;
            for (javax.servlet.http.Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (cookieName.startsWith(sessionCookieName)) {
                    Throwable cause;
                    String sessionId = cookie.getValue();
                    session = sessiondService.getSession(sessionId);
                    if (null == session) continue;
                    if (!this.conf.isIpCheck()) {
                        LoginTools.updateIPAddress(this.conf, req.getRemoteAddr(), session);
                    } else {
                        String newIP = req.getRemoteAddr();
                        SessionUtility.checkIP(true, this.conf.getRanges(), session, newIP, this.conf.getIpCheckWhitelist());
                        LoginTools.updateIPAddress(this.conf, newIP, session);
                    }
                    try {
                        Context ctx = ContextStorage.getInstance().getContext(session.getContextId());
                        if (!ctx.isEnabled()) {
                            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
                        }
                        User user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
                        if (!user.isMailEnabled()) {
                            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
                        }
                    }
                    catch (UndeclaredThrowableException e) {
                        throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                    }
                    Future<JSONObject> optRampUp = this.rampUpAsync(ServerSessionAdapter.valueOf(session), req);
                    Future<Object> optModules = this.getModulesAsync(session, req);
                    JSONObject json = new JSONObject(8);
                    LoginWriter.write(session, json);
                    if (null != optModules) {
                        try {
                            Object oModules = optModules.get();
                            if (null != oModules) {
                                json.put("modules", oModules);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{"Thread interrupted."});
                        }
                        catch (ExecutionException e) {
                            cause = e.getCause();
                            LOG.warn("Modules could not be added to login JSON response", cause);
                        }
                    }
                    if (null != optRampUp) {
                        try {
                            JSONObject jsonObject = optRampUp.get();
                            for (Map.Entry entry : jsonObject.entrySet()) {
                                json.put((String)entry.getKey(), entry.getValue());
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{"Thread interrupted."});
                        }
                        catch (ExecutionException e) {
                            cause = e.getCause();
                            LOG.warn("Ramp-up information could not be added to login JSON response", cause);
                        }
                    }
                    response.setData(json);
                    if (null == secret) continue;
                    break;
                }
                if (!cookieName.startsWith(secretCookieName)) continue;
                secret = cookie.getValue();
                if (null != session) break;
            }
            if (null == response.getData() || session == null || secret == null || !session.getSecret().equals(secret)) {
                SessionUtility.removeOXCookies(hash, req, resp);
                SessionUtility.removeJSESSIONID(req, resp);
                if (this.doAutoLogin(req, resp)) {
                    if (Reply.STOP == SessionInspector.getInstance().getChain().onAutoLoginFailed(Reason.AUTO_LOGIN_FAILED, req, resp)) {
                        return;
                    }
                    throw OXJSONExceptionCodes.INVALID_COOKIE.create();
                }
                return;
            }
            LoginServlet.writePublicSessionCookie(req, resp, session, req.isSecure(), req.getServerName(), this.conf);
        }
        catch (OXException e) {
            if (AjaxExceptionCodes.DISABLED_ACTION.equals(e)) {
                LOG.debug("", (Throwable)e);
            } else {
                switch (((Category)e.getCategories().get(0)).getLogLevel()) {
                    case TRACE: {
                        LOG.trace("", (Throwable)e);
                        break;
                    }
                    case DEBUG: {
                        LOG.debug("", (Throwable)e);
                        break;
                    }
                    case INFO: {
                        LOG.info("", (Throwable)e);
                        break;
                    }
                    case WARNING: {
                        LOG.warn("", (Throwable)e);
                        break;
                    }
                    case ERROR: {
                        LOG.error("", (Throwable)e);
                        break;
                    }
                }
            }
            if (SessionUtility.isIpCheckError(e) && null != session) {
                try {
                    SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                    SessionUtility.removeOXCookies(session.getHash(), req, resp);
                    SessionUtility.removeJSESSIONID(req, resp);
                    sessiondService.removeSession(session.getSessionID());
                }
                catch (Exception e2) {
                    LOG.error("Cookies could not be removed.", (Throwable)e2);
                }
            }
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error("", (Throwable)oje);
            response.setException(oje);
        }
        Tools.disableCaching(resp);
        resp.setStatus(200);
        resp.setContentType("text/javascript; charset=UTF-8");
        try {
            if (response.hasError()) {
                ResponseWriter.write(response, resp.getWriter(), LoginServlet.localeFrom(session));
            } else {
                ((JSONObject)response.getData()).write((Writer)resp.getWriter());
            }
        }
        catch (JSONException e) {
            LOG.error("Error while writing response object.", (Throwable)e);
            LoginServlet.sendError(resp);
        }
    }

    private boolean doAutoLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, OXException {
        return this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                LoginRequest request = AutoLogin.this.parseAutoLoginRequest(req2);
                return LoginPerformer.getInstance().doAutoLogin(request);
            }
        }, this.conf);
    }

    private LoginRequest parseAutoLoginRequest(HttpServletRequest req) throws OXException {
        String authId = LoginTools.parseAuthId(req, false);
        String client = LoginTools.parseClient(req, false, this.conf.getDefaultClient());
        String clientIP = LoginTools.parseClientIP(req);
        String userAgent = LoginTools.parseUserAgent(req);
        Map<String, List<String>> headers = Tools.copyHeaders(req);
        Cookie[] cookies = Tools.getCookieFromHeader(req);
        String httpSessionId = req.getSession(true).getId();
        return new LoginRequestImpl(null, null, clientIP, userAgent, authId, client, null, HashCalculator.getInstance().getHash(req, client), Interface.HTTP_JSON, headers, cookies, Tools.considerSecure(req, this.conf.isCookieForceHTTPS()), req.getServerName(), req.getServerPort(), httpSessionId);
    }
}

