/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.SessionServletInterceptor;
import com.openexchange.ajax.SessionServletInterceptorRegistry;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.log.LogProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Reply;
import com.openexchange.session.Session;
import com.openexchange.session.SessionResult;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.ThreadLocalSessionHolder;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.servlet.ratelimit.RateLimitedException;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpStatus;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionServlet
extends AJAXServlet {
    private static final long serialVersionUID = -8308340875362868795L;
    private static final Logger LOG = LoggerFactory.getLogger(SessionServlet.class);
    public static final String SESSION_KEY = "sessionObject";
    public static final String SESSION_WHITELIST_FILE = "noipcheck.cnf";
    private final String sessionErrorPrefix;
    private static final String USM_USER_AGENT = "Open-Xchange USM HTTP Client";
    private static volatile Integer maxConcurrentRequests;

    protected SessionServlet() {
        SessionUtility.initialize();
        this.sessionErrorPrefix = SessionExceptionCodes.getErrorPrefix();
    }

    protected SessionResult<ServerSession> initializeSession(HttpServletRequest req, HttpServletResponse resp) throws OXException {
        return SessionUtility.defaultInitializeSession(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Tools.disableCaching(resp);
        AtomicInteger counter = null;
        SessionThreadCounter threadCounter = (SessionThreadCounter)SessionThreadCounter.REFERENCE.get();
        ServerSession session = null;
        String sessionId = null;
        try {
            resp.setStatus(200);
            resp.setContentType("text/javascript; charset=UTF-8");
            SessionResult<ServerSession> result = this.initializeSession(req, resp);
            if (Reply.STOP == result.getReply()) {
                return;
            }
            session = (ServerSession)result.getSession();
            if (null != session) {
                String dbSchema = (String)session.getParameter(LogProperties.Name.DATABASE_SCHEMA.getName());
                if (dbSchema == null) {
                    DatabaseService dbService = ServerServiceRegistry.getServize(DatabaseService.class, true);
                    dbSchema = dbService.getSchemaName(session.getContextId());
                    session.setParameter(LogProperties.Name.DATABASE_SCHEMA.getName(), dbSchema);
                }
                LogProperties.put((LogProperties.Name)LogProperties.Name.DATABASE_SCHEMA, (Object)dbSchema);
                LogProperties.putSessionProperties((Session)session);
                int maxConcurrentRequests = SessionServlet.getMaxConcurrentRequests(session);
                if (maxConcurrentRequests > 0 && null != (counter = (AtomicInteger)session.getParameter(Session.PARAM_COUNTER)) && counter.incrementAndGet() > maxConcurrentRequests) {
                    LOG.info("User {} in context {} exceeded max. concurrent requests ({}).", new Object[]{session.getUserId(), session.getContextId(), maxConcurrentRequests});
                    throw AjaxExceptionCodes.TOO_MANY_REQUESTS.create();
                }
                ThreadLocalSessionHolder.getInstance().setSession(session);
                if (null != threadCounter) {
                    sessionId = session.getSessionID();
                    threadCounter.increment(sessionId);
                }
                for (SessionServletInterceptor interceptor : SessionServletInterceptorRegistry.getInstance().getInterceptors()) {
                    interceptor.intercept(session);
                }
            }
            super.service(req, resp);
        }
        catch (RateLimitedException e) {
            resp.setContentType("text/plain; charset=UTF-8");
            if (e.getRetryAfter() > 0) {
                resp.setHeader("Retry-After", String.valueOf(e.getRetryAfter()));
            }
            resp.sendError(429, "Too Many Requests - Your request is being rate limited.");
        }
        catch (OXException e) {
            Locale locale = this.getLocaleFrom(session, null);
            if (null != locale) {
                e.setProperty("com.openexchange.exception.locale", locale.toString());
            }
            this.handleOXException(e, req, resp);
        }
        finally {
            if (null != sessionId && null != threadCounter) {
                threadCounter.decrement(sessionId);
            }
            ThreadLocalSessionHolder.getInstance().clear();
            LogProperties.removeSessionProperties();
            LogProperties.removeProperty((LogProperties.Name)LogProperties.Name.DATABASE_SCHEMA);
            if (null != counter) {
                counter.getAndDecrement();
            }
        }
    }

    protected void superService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    protected Locale getLocaleFrom(ServerSession session, Locale defaultLocale) {
        if (null == session) {
            return defaultLocale;
        }
        User user = session.getUser();
        return null == user ? defaultLocale : user.getLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSessiondException(OXException e, HttpServletRequest req, HttpServletResponse resp) {
        if (SessionUtility.isIpCheckError(e)) {
            try {
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                String sessionId = SessionUtility.getSessionId((ServletRequest)req);
                SessionResult<ServerSession> result = SessionUtility.getSession(req, resp, sessionId, sessiondService);
                if (null != result.getSession()) {
                    SessionUtility.removeOXCookies(((ServerSession)result.getSession()).getHash(), req, resp);
                }
                SessionUtility.removeJSESSIONID(req, resp);
                sessiondService.removeSession(sessionId);
            }
            catch (Exception e2) {
                LOG.error("Cookies could not be removed.", (Throwable)e2);
            }
            finally {
                LogProperties.removeSessionProperties();
            }
        }
    }

    protected void writeErrorAsJsCallback(OXException e, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        try {
            APIResponseRenderer.writeJsCallback(new Response().setException(e), Dispatchers.getActionFrom(httpRequest), httpRequest, httpResponse);
        }
        catch (JSONException je) {
            LOG.error("", (Throwable)e);
            try {
                httpResponse.sendError(500, "A JSON error occurred: " + e.getMessage());
            }
            catch (IOException ioe) {
                LOG.error("", (Throwable)ioe);
            }
        }
    }

    protected void handleOXException(OXException e, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleOXException(e, req, resp, true, true);
    }

    protected void handleOXException(OXException e, HttpServletRequest req, HttpServletResponse resp, boolean checkUploadQuota, boolean doLog) throws IOException {
        this.handleOXException(e, 500, "An error occurred inside the server which prevented it from fulfilling the request.", req, resp, checkUploadQuota, doLog);
    }

    protected void handleOXException(OXException e, int statusCode, String reasonPhrase, HttpServletRequest req, HttpServletResponse resp, boolean checkUploadQuota, boolean doLog) throws IOException {
        if (checkUploadQuota && (UploadException.UploadCode.MAX_UPLOAD_SIZE_EXCEEDED.equals(e) || UploadException.UploadCode.MAX_UPLOAD_FILE_SIZE_EXCEEDED.equals(e))) {
            LOG.debug("", (Throwable)e);
            String sLoc = e.getProperty("com.openexchange.exception.locale");
            resp.sendError(413, e.getDisplayMessage(null == sLoc ? Locale.US : LocaleTools.getLocale((String)sLoc)));
        } else if (this.sessionErrorPrefix.equals(e.getPrefix())) {
            LOG.debug("", (Throwable)e);
            this.handleSessiondException(e, req, resp);
            if (Dispatchers.isApiOutputExpectedFor(req)) {
                APIResponseRenderer.writeResponse(new Response().setException(e), Dispatchers.getActionFrom(req), req, resp);
            } else if (USM_USER_AGENT.equals(req.getHeader("User-Agent"))) {
                this.writeErrorAsJsCallback(e, req, resp);
            } else {
                String desc = e.getMessage();
                resp.setStatus(403);
                SessionServlet.writeErrorPage(403, desc, resp);
            }
        } else {
            if (doLog) {
                switch (((Category)e.getCategories().get(0)).getLogLevel()) {
                    case TRACE: {
                        LOG.trace("", (Throwable)e);
                        break;
                    }
                    case DEBUG: {
                        LOG.debug("", (Throwable)e);
                        break;
                    }
                    case INFO: {
                        LOG.info("", (Throwable)e);
                        break;
                    }
                    case WARNING: {
                        LOG.warn("", (Throwable)e);
                        break;
                    }
                    case ERROR: {
                        LOG.error("", (Throwable)e);
                        break;
                    }
                }
            }
            if (Dispatchers.isApiOutputExpectedFor(req)) {
                APIResponseRenderer.writeResponse(new Response().setException(e), Dispatchers.getActionFrom(req), req, resp);
            } else if (USM_USER_AGENT.equals(req.getHeader("User-Agent"))) {
                this.writeErrorAsJsCallback(e, req, resp);
            } else {
                String desc = null == reasonPhrase ? "An error occurred inside the server which prevented it from fulfilling the request." : reasonPhrase;
                resp.setStatus(statusCode);
                SessionServlet.writeErrorPage(statusCode, desc, resp);
            }
        }
    }

    public static void writeErrorPage(int statusCode, String desc, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html; charset=UTF-8");
        resp.setHeader("Content-Disposition", "inline");
        PrintWriter writer = resp.getWriter();
        writer.write(SessionServlet.getErrorPage(statusCode, null, desc));
        writer.flush();
    }

    protected String getErrorPage(int sc) {
        return SessionServlet.getErrorPage(sc, null, null);
    }

    public static String getErrorPage(int sc, String msg, String desc) {
        String desc0;
        String msg0 = null == msg ? HttpStatus.getStatusText((int)sc) : msg;
        StringBuilder sb = new StringBuilder(512);
        String lineSep = System.getProperty("line.separator");
        sb.append("<!DOCTYPE html>").append(lineSep);
        sb.append("<html><head>").append(lineSep);
        sb.append("<title>").append(sc);
        if (null != msg0) {
            sb.append(' ').append(msg0);
        }
        sb.append("</title>").append(lineSep);
        sb.append("</head><body>").append(lineSep);
        sb.append("<h1>");
        if (null == msg0) {
            sb.append(sc);
        } else {
            sb.append(msg0);
        }
        sb.append("</h1>").append(lineSep);
        String string = desc0 = null == desc ? msg0 : desc;
        if (null != desc0) {
            sb.append("<p>").append(desc0).append("</p>").append(lineSep);
        }
        sb.append("</body></html>").append(lineSep);
        return sb.toString();
    }

    protected ServerSession getSessionObject(ServletRequest req) {
        return SessionUtility.getSessionObject(req, false);
    }

    protected ServerSession getSessionObject(ServletRequest req, boolean mayUseFallbackSession) {
        return SessionUtility.getSessionObject(req, mayUseFallbackSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getMaxConcurrentRequests(ServerSession session) {
        Integer tmp = maxConcurrentRequests;
        if (null != tmp) return tmp;
        Class<SessionServlet> clazz = SessionServlet.class;
        synchronized (SessionServlet.class) {
            tmp = maxConcurrentRequests;
            if (null != tmp) return tmp;
            tmp = maxConcurrentRequests = Integer.valueOf(SessionServlet.getMaxConcurrentRequests0(session));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tmp;
        }
    }

    private static int getMaxConcurrentRequests0(ServerSession session) {
        if (session == null) {
            return 0;
        }
        Set<String> set = session.getUser().getAttributes().get("ajax.maxCount");
        if (null == set || set.isEmpty()) {
            try {
                return ServerConfig.getInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS);
            }
            catch (OXException e) {
                return Integer.parseInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS.getDefaultValue());
            }
        }
        try {
            return Integer.parseInt(set.iterator().next());
        }
        catch (NumberFormatException e) {
            try {
                return ServerConfig.getInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS);
            }
            catch (OXException oxe) {
                return Integer.parseInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS.getDefaultValue());
            }
        }
    }
}

