/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.tools.file.internal.AbstractHashingFileStorageTest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentSaveDeleteHashingFileStorageTest
extends AbstractHashingFileStorageTest {
    private final List<String> FILES = new CopyOnWriteArrayList<String>();
    private final int NUM_FILES_INIT = 100;
    private final int NUM_OPERATIONS = 1000;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        for (int i = 1; i <= 100; ++i) {
            String content = "Content of file " + i;
            this.FILES.add(this.fs.saveNewFile(this.IS(content)));
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.fs.remove();
        super.tearDown();
    }

    public void testBug34249ConcurrentThreads() throws Exception {
        FsThread save = new FsThread(true);
        FsThread delete = new FsThread(false);
        save.start();
        delete.start();
        try {
            save.join();
            delete.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (save.hasException()) {
            ConcurrentSaveDeleteHashingFileStorageTest.fail((String)("Exception while saving: " + save.getException().getMessage()));
        }
        if (delete.hasException()) {
            ConcurrentSaveDeleteHashingFileStorageTest.fail((String)("Exception while deleting: " + delete.getException().getMessage()));
        }
        this.checkForEmptyFolders(this.fs.storage);
    }

    private void checkForEmptyFolders(File root) throws Exception {
        if (root.isDirectory()) {
            if (root.listFiles().length == 0) {
                ConcurrentSaveDeleteHashingFileStorageTest.fail((String)("Empty folder found: " + root.getAbsolutePath()));
            }
            for (File file : root.listFiles()) {
                this.checkForEmptyFolders(file);
            }
        }
    }

    private class FsThread
    extends Thread {
        private boolean exception;
        private final boolean save;
        private Exception ex;

        public FsThread(boolean save) {
            this.save = save;
            this.exception = false;
            this.ex = null;
        }

        public Exception getException() {
            return this.ex;
        }

        public boolean hasException() {
            return this.exception;
        }

        @Override
        public void run() {
            for (int i = 1; i <= 1000; ++i) {
                if (this.save) {
                    String content = "New file " + i;
                    try {
                        ConcurrentSaveDeleteHashingFileStorageTest.this.FILES.add(ConcurrentSaveDeleteHashingFileStorageTest.this.fs.saveNewFile(ConcurrentSaveDeleteHashingFileStorageTest.this.IS(content)));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.exception = false;
                        this.ex = e;
                        break;
                    }
                    catch (OXException e) {
                        this.exception = false;
                        this.ex = e;
                        break;
                    }
                }
                int id = new Random(System.currentTimeMillis()).nextInt(ConcurrentSaveDeleteHashingFileStorageTest.this.FILES.size());
                try {
                    ConcurrentSaveDeleteHashingFileStorageTest.this.fs.deleteFile((String)ConcurrentSaveDeleteHashingFileStorageTest.this.FILES.get(id));
                    continue;
                }
                catch (OXException e) {
                    this.exception = true;
                    this.ex = e;
                    break;
                }
            }
        }
    }
}

