/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.quotachecker;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.quotachecker.MailUploadQuotaChecker;
import com.openexchange.mail.usersetting.UserSettingMail;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserSettingMail.class, ServerConfig.class})
public class MailUploadQuotaCheckerTest {
    private MailUploadQuotaChecker mailUploadQuotaChecker;
    @Mock
    private UserSettingMail userSettingMail;
    private long quota = 10000000L;
    private int quotaFromFile = 9999;
    private int unlimitedQuota = 0;
    private int unlimitedQuota2 = -1;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(ServerConfig.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ServerConfig.getInt((ServerConfig.Property)((ServerConfig.Property)Matchers.any()))).thenReturn((Object)this.quotaFromFile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMailUploadQuotaCheckerUserSettingMail_userSettingsNull_throwException() {
        this.mailUploadQuotaChecker = new MailUploadQuotaChecker(null);
    }

    @Test
    public void testMailUploadQuotaCheckerUserSettingMail_bothZero_maxQuotaZero() {
        this.mailUploadQuotaChecker = new MailUploadQuotaChecker(this.userSettingMail);
        long quotaMax = this.mailUploadQuotaChecker.getQuotaMax();
        Assert.assertEquals((long)this.unlimitedQuota, (long)quotaMax);
    }

    @Test
    public void testMailUploadQuotaCheckerUserSettingMail_bothZero_maxQuotaPerFileNegativ() {
        this.mailUploadQuotaChecker = new MailUploadQuotaChecker(this.userSettingMail);
        long fileQuotaMax = this.mailUploadQuotaChecker.getFileQuotaMax();
        Assert.assertEquals((long)this.unlimitedQuota2, (long)fileQuotaMax);
    }

    @Test
    public void testMailUploadQuotaCheckerUserSettingMail_uploadQuotaSetInDB_setUploadQuota() {
        Mockito.when((Object)this.userSettingMail.getUploadQuota()).thenReturn((Object)this.quota);
        this.mailUploadQuotaChecker = new MailUploadQuotaChecker(this.userSettingMail);
        long quotaMax = this.mailUploadQuotaChecker.getQuotaMax();
        Assert.assertEquals((long)this.quota, (long)quotaMax);
    }

    @Test
    public void testMailUploadQuotaCheckerUserSettingMail_uploadQuotaPerFileSetInDB_setUploadQuotaPerFile() {
        Mockito.when((Object)this.userSettingMail.getUploadQuotaPerFile()).thenReturn((Object)this.quota);
        this.mailUploadQuotaChecker = new MailUploadQuotaChecker(this.userSettingMail);
        long fileQuotaMax = this.mailUploadQuotaChecker.getFileQuotaMax();
        Assert.assertEquals((long)this.quota, (long)fileQuotaMax);
    }

    @Test
    public void testMailUploadQuotaCheckerUserSettingMail_uploadQuotaNegativ_setUploadQuotaFromServerProperties() {
        Mockito.when((Object)this.userSettingMail.getUploadQuota()).thenReturn((Object)-1L);
        this.mailUploadQuotaChecker = new MailUploadQuotaChecker(this.userSettingMail);
        long quotaMax = this.mailUploadQuotaChecker.getQuotaMax();
        Assert.assertEquals((long)this.quotaFromFile, (long)quotaMax);
        Assert.assertEquals((long)this.unlimitedQuota2, (long)this.mailUploadQuotaChecker.getFileQuotaMax());
    }

    @Test
    public void testMailUploadQuotaCheckerUserSettingMail_uploadQuotaNegativAndServerConfigException_setUploadQuotaToZero() throws OXException {
        Mockito.when((Object)this.userSettingMail.getUploadQuota()).thenReturn((Object)-1L);
        PowerMockito.when((Object)ServerConfig.getInt((ServerConfig.Property)((ServerConfig.Property)Matchers.any()))).thenThrow(new Throwable[]{new OXException()});
        this.mailUploadQuotaChecker = new MailUploadQuotaChecker(this.userSettingMail);
        long quotaMax = this.mailUploadQuotaChecker.getQuotaMax();
        Assert.assertEquals((long)this.unlimitedQuota, (long)quotaMax);
        Assert.assertEquals((long)this.unlimitedQuota2, (long)this.mailUploadQuotaChecker.getFileQuotaMax());
    }
}

