/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public final class ServiceContainer<S> {
    private static final String SERVICE_RANKING = "service.ranking";
    private final S service;
    private int ranking;
    private final Map<String, Object> properties;

    public ServiceContainer(S service) {
        this(service, 0);
    }

    public ServiceContainer(S service, int ranking) {
        this.service = service;
        this.ranking = ranking;
        this.properties = new HashMap<String, Object>(6);
        this.properties.put(SERVICE_RANKING, ranking);
    }

    public void addProperties(Dictionary<String, Object> properties) {
        if (null == properties || properties.isEmpty()) {
            return;
        }
        Map<String, Object> thisProperties = this.properties;
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = properties.get(key);
            if (null == value) continue;
            if (SERVICE_RANKING.equals(key)) {
                this.ranking = (Integer)value;
            }
            thisProperties.put(key, value);
        }
    }

    public void addProperties(Map<String, Object> properties) {
        if (null == properties || properties.isEmpty()) {
            return;
        }
        if (properties.containsKey(SERVICE_RANKING)) {
            this.ranking = ServiceContainer.getRanking(properties);
        }
        this.properties.putAll(properties);
    }

    public void removeProperties(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Map<String, Object> thisProperties = this.properties;
        for (String key : keys) {
            if (SERVICE_RANKING.equals(key)) {
                this.ranking = 0;
            }
            thisProperties.remove(key);
        }
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public S getService() {
        return this.service;
    }

    public int getRanking() {
        return this.ranking;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
        this.properties.put(SERVICE_RANKING, ranking);
    }

    private static int getRanking(Map<String, Object> properties) {
        Object property = properties.get(SERVICE_RANKING);
        if (null == property) {
            return 0;
        }
        return (Integer)property;
    }
}

