/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

public final class StringAppender {
    private final StringBuilder sb;
    private final String delim;
    private boolean first = true;

    public StringAppender(char delim) {
        this(delim, 256);
    }

    public StringAppender(char delim, int initialCapacity) {
        this.sb = new StringBuilder(initialCapacity);
        this.delim = String.valueOf(delim);
    }

    public StringAppender(String delim) {
        this(delim, 256);
    }

    public StringAppender(String delim, int initialCapacity) {
        this.sb = new StringBuilder(initialCapacity);
        this.delim = null == delim ? "null" : delim;
    }

    public String toString() {
        return this.sb.toString();
    }

    public int length() {
        return this.sb.length();
    }

    public StringAppender append(boolean b) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(b);
        return this;
    }

    public StringAppender append(char c) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(c);
        return this;
    }

    public StringAppender append(int i) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(i);
        return this;
    }

    public StringAppender append(long l) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(l);
        return this;
    }

    public StringAppender append(float f) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(f);
        return this;
    }

    public StringAppender append(double d) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(d);
        return this;
    }

    public StringAppender append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringAppender append(String str) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(str);
        return this;
    }

    public StringAppender append(StringBuffer sb) {
        if (this.first) {
            this.first = false;
        } else {
            sb.append(this.delim);
        }
        sb.append(sb);
        return this;
    }

    public StringAppender append(StringBuilder sb) {
        if (this.first) {
            this.first = false;
        } else {
            sb.append(this.delim);
        }
        sb.append((CharSequence)sb);
        return this;
    }

    public StringAppender append(CharSequence s) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(s);
        return this;
    }

    public StringAppender append(CharSequence s, int start, int end) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(s, start, end);
        return this;
    }

    public StringAppender append(char[] str) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delim);
        }
        this.sb.append(str);
        return this;
    }
}

