/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SequentialCompletionService<V>
implements CompletionService<V>,
Closeable {
    static final FutureTask POISON = new EmptyFutureTask();
    private final BlockingQueue<FutureTask<V>> submittedTasks;
    private final BlockingQueue<Future<V>> requestTaskQueue;
    private final ExecuterCallable<V> consumer;

    public SequentialCompletionService(ExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        LinkedBlockingQueue submittedTasks = new LinkedBlockingQueue();
        LinkedBlockingQueue requestTaskQueue = new LinkedBlockingQueue();
        ExecuterCallable consumer = new ExecuterCallable(submittedTasks, requestTaskQueue);
        executor.submit(consumer);
        this.consumer = consumer;
        this.requestTaskQueue = requestTaskQueue;
        this.submittedTasks = submittedTasks;
    }

    public void shutDown() {
        this.consumer.cancel();
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        FutureTask<V> ft = new FutureTask<V>(task);
        this.submittedTasks.offer(ft);
        return ft;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        FutureTask<V> ft = new FutureTask<V>(task, result);
        this.submittedTasks.offer(ft);
        return ft;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.requestTaskQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.requestTaskQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.requestTaskQueue.poll(timeout, unit);
    }

    @Override
    public void close() {
        this.shutDown();
    }

    private static class ExecuterCallable<V>
    implements Callable<Void> {
        private final BlockingQueue<FutureTask<V>> submittedTasks;
        private final BlockingQueue<Future<V>> requestTaskQueue;

        ExecuterCallable(BlockingQueue<FutureTask<V>> submittedTasks, BlockingQueue<Future<V>> requestTaskQueue) {
            this.submittedTasks = submittedTasks;
            this.requestTaskQueue = requestTaskQueue;
        }

        void cancel() {
            this.submittedTasks.add(POISON);
        }

        @Override
        public Void call() throws Exception {
            boolean keepOn = true;
            ArrayList tasks = new ArrayList();
            while (keepOn) {
                FutureTask<V> first = this.submittedTasks.take();
                if (POISON == first) {
                    return null;
                }
                this.execute(first);
                tasks.clear();
                this.submittedTasks.drainTo(tasks);
                for (FutureTask c : tasks) {
                    if (POISON == c) {
                        return null;
                    }
                    this.execute(c);
                }
            }
            return null;
        }

        private void execute(FutureTask<V> task) {
            task.run();
            this.requestTaskQueue.offer(task);
        }
    }

    private static class EmptyFutureTask<V>
    extends FutureTask<V> {
        EmptyFutureTask() {
            super(new EmptyCallable());
        }
    }

    private static class EmptyCallable<V>
    implements Callable<V> {
        EmptyCallable() {
        }

        @Override
        public V call() throws Exception {
            return null;
        }
    }
}

