/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.log.AbstractDelegatingLogger;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
extends AbstractDelegatingLogger {
    private static final String FQCN = Slf4jLogger.class.getName();
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;

    public Slf4jLogger(Class<?> clazz) {
        super(clazz.getName(), null);
        this.logger = LoggerFactory.getLogger(clazz);
        this.locationAwareLogger = this.logger instanceof LocationAwareLogger ? (LocationAwareLogger)this.logger : null;
    }

    public Slf4jLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.logger = LoggerFactory.getLogger((String)name);
        this.locationAwareLogger = this.logger instanceof LocationAwareLogger ? (LocationAwareLogger)this.logger : null;
    }

    @Override
    public void log(Level level, String msg) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, null);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, msg, null, null);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, msg, null, null);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, null);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, msg, null, null);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, null);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, null);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, null);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, new Object[]{param1}, (ResourceBundle)null), null, null);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, params, (ResourceBundle)null));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, (ResourceBundle)null), null, null);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void log(Level level, String msg, Throwable t) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, msg, null, t);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, msg, null, t);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, msg, null, t);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, t);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, t);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void info(String msg) {
        if (this.locationAwareLogger == null) {
            this.logger.info(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 20, msg, null, null);
        }
    }

    @Override
    public void fine(String msg) {
        if (this.locationAwareLogger == null) {
            this.logger.debug(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 10, msg, null, null);
        }
    }

    @Override
    public void finer(String msg) {
        if (this.locationAwareLogger == null) {
            this.logger.trace(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 0, msg, null, null);
        }
    }

    @Override
    public void finest(String msg) {
        if (this.locationAwareLogger == null) {
            this.logger.trace(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 0, msg, null, null);
        }
    }

    @Override
    public void warning(String msg) {
        if (this.locationAwareLogger == null) {
            this.logger.warn(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 30, msg, null, null);
        }
    }

    @Override
    public void severe(String msg) {
        if (this.locationAwareLogger == null) {
            this.logger.error(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 40, msg, null, null);
        }
    }

    @Override
    public void config(String msg) {
        if (this.locationAwareLogger == null) {
            this.logger.debug(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 10, msg, null, null);
        }
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.locationAwareLogger == null) {
            this.logger.trace("", thrown);
        } else {
            this.locationAwareLogger.log(null, FQCN, 0, thrown.getMessage(), null, thrown);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable t) {
        this.log(level, msg, t);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, null, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, null, bundleName), null, null);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, new Object[]{param1}, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, new Object[]{param1}, bundleName), null, null);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, params, bundleName));
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, bundleName), null, null);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable t) {
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, null, bundleName), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, null, bundleName), null, t);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    public void log(LogRecord record) {
        Level level = record.getLevel();
        String msg = record.getMessage();
        Throwable t = record.getThrown();
        Object[] params = record.getParameters();
        ResourceBundle resourceBundle = record.getResourceBundle();
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(this.formatMessage(msg, params, resourceBundle), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, this.formatMessage(msg, params, resourceBundle), null, t);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }

    @Override
    protected boolean supportsHandlers() {
        return true;
    }

    @Override
    public Level getLevel() {
        Level level = this.logger.isTraceEnabled() ? Level.FINEST : (this.logger.isDebugEnabled() ? Level.FINER : (this.logger.isInfoEnabled() ? Level.INFO : (this.logger.isWarnEnabled() ? Level.WARNING : (this.logger.isErrorEnabled() ? Level.SEVERE : Level.OFF))));
        return level;
    }

    @Override
    public boolean isLoggable(Level level) {
        int i = level.intValue();
        if (i == Level.OFF.intValue()) {
            return false;
        }
        if (i >= Level.SEVERE.intValue()) {
            return this.logger.isErrorEnabled();
        }
        if (i >= Level.WARNING.intValue()) {
            return this.logger.isWarnEnabled();
        }
        if (i >= Level.INFO.intValue()) {
            return this.logger.isInfoEnabled();
        }
        if (i >= Level.FINER.intValue()) {
            return this.logger.isDebugEnabled();
        }
        return this.logger.isTraceEnabled();
    }

    @Override
    protected void internalLogFormatted(String msg, LogRecord record) {
        Level level = record.getLevel();
        Throwable t = record.getThrown();
        Handler[] targets = this.getHandlers();
        if (targets != null) {
            for (Handler h : targets) {
                h.publish(record);
            }
        }
        if (!this.getUseParentHandlers()) {
            return;
        }
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, msg, null, t);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, msg, null, t);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, msg, null, t);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, t);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, t);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }
}

