/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import com.openexchange.cli.ReservedOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public abstract class AbstractCLI {
    protected Options options;

    protected AbstractCLI() {
    }

    protected ReservedOptions newOptions() {
        ReservedOptions options = new ReservedOptions();
        this.options = options;
        return options;
    }

    protected void checkOptions(CommandLine cmd, Options options) {
        this.checkOptions(cmd);
    }

    protected abstract void checkOptions(CommandLine var1);

    protected abstract boolean requiresAdministrativePermission();

    protected void printHelp(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(74, this.getName(), null, options, this.getFooter(), false);
    }

    protected abstract String getFooter();

    protected abstract String getName();

    protected int parsePort(char opt, int defaultValue, CommandLine cmd, Options options) {
        int port = defaultValue;
        String sPort = cmd.getOptionValue(opt);
        if (null != sPort) {
            try {
                port = Integer.parseInt(sPort.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Port parameter is not a number: " + sPort);
                this.printHelp(options);
                System.exit(1);
            }
        }
        if (port < 1 || port > 65535) {
            System.err.println("Port parameter is out of range: " + sPort + ". Valid range is from 1 to 65535.");
            this.printHelp(options);
            System.exit(1);
        }
        return port;
    }

    protected int parseInt(char opt, int defaultValue, CommandLine cmd, Options options) {
        int i = defaultValue;
        String sInt = cmd.getOptionValue(opt);
        if (null != sInt) {
            try {
                i = Integer.parseInt(sInt.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Integer parameter is not a number: " + sInt);
                this.printHelp(options);
                System.exit(1);
            }
        }
        return i;
    }
}

