/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.global.tools.id;

import com.openexchange.tools.id.IDMangler;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class IDManglerTest
extends TestCase {
    public void testRoundtrip() {
        String id = IDMangler.mangle((String[])new String[]{"com.openexchange.some.service", "someFolder", "someId"});
        IDManglerTest.assertNotNull((Object)id);
        List unmangled = IDMangler.unmangle((String)id);
        IDManglerTest.assertEquals(Arrays.asList("com.openexchange.some.service", "someFolder", "someId"), (Object)unmangled);
    }

    public void testSlashes() {
        String id = IDMangler.mangle((String[])new String[]{"com.openexchange.some.service", "someFolder/folder/with/slashes", "someId"});
        IDManglerTest.assertNotNull((Object)id);
        List unmangled = IDMangler.unmangle((String)id);
        IDManglerTest.assertEquals(Arrays.asList("com.openexchange.some.service", "someFolder/folder/with/slashes", "someId"), (Object)unmangled);
    }

    public void testSpecialCharacters() {
        String id = IDMangler.mangle((String[])new String[]{"com.openexchange.some.service", "someFolder/folder/with/slashes and whitespace and f\u00ac\u00df)($nny ch$\u00ac\u00df\u00ac\u00df$\u221a\u00f2\u221a\u00e8\u221a\u00e8\u221a\u00e7r\u00ac\u00df$ter$", "someId"});
        IDManglerTest.assertNotNull((Object)id);
        List unmangled = IDMangler.unmangle((String)id);
        IDManglerTest.assertEquals(Arrays.asList("com.openexchange.some.service", "someFolder/folder/with/slashes and whitespace and f\u00ac\u00df)($nny ch$\u00ac\u00df\u00ac\u00df$\u221a\u00f2\u221a\u00e8\u221a\u00e8\u221a\u00e7r\u00ac\u00df$ter$", "someId"), (Object)unmangled);
    }

    public void testBrackets() {
        String id = IDMangler.mangle((String[])new String[]{"some", "com[ponents", "wi]]th", "brackets"});
        IDManglerTest.assertNotNull((Object)id);
        List unmangled = IDMangler.unmangle((String)id);
        IDManglerTest.assertEquals(Arrays.asList("some", "com[ponents", "wi]]th", "brackets"), (Object)unmangled);
    }

    public void testBackslash() {
        String id = IDMangler.mangle((String[])new String[]{"something\\with", "neato\\backslashes"});
        IDManglerTest.assertNotNull((Object)id);
        List unmangled = IDMangler.unmangle((String)id);
        IDManglerTest.assertEquals(Arrays.asList("something\\with", "neato\\backslashes"), (Object)unmangled);
    }

    public void testContainsPrimaryDelim() {
        List unmangled = IDMangler.unmangle((String)"some:/partial:id://component");
        IDManglerTest.assertEquals(Arrays.asList("some:/partial:id", "component"), (Object)unmangled);
    }

    public void testContainsFragmentsOfPrimaryDelim() {
        String id = IDMangler.mangle((String[])new String[]{"some:/service:this is", "someFolder", "someId"});
        IDManglerTest.assertNotNull((Object)id);
        List unmangled = IDMangler.unmangle((String)id);
        IDManglerTest.assertEquals(Arrays.asList("some:/service:this is", "someFolder", "someId"), (Object)unmangled);
    }

    public void testInfostoreFolderAndId() {
        List unmangled = IDMangler.unmangle((String)"123/456");
        IDManglerTest.assertEquals((String)"Unexpected size", (int)2, (int)unmangled.size());
        IDManglerTest.assertEquals((String)"123", (String)((String)unmangled.get(0)));
        IDManglerTest.assertEquals((String)"456", (String)((String)unmangled.get(1)));
    }
}

