/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.config.ConfigurationService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

@Action(method=RequestMethod.PUT, name="zipfolder", description="Gets a ZIP archive for a folder's infoitems", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder_id", description="A folder identifier."), @Parameter(name="recursive", description="true or false")}, responseDescription="The ZIP archive binary data")
@DispatcherNotes(defaultFormat="file")
public class ZipFolderAction
extends AbstractFileAction {
    private static volatile Long threshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long threshold() {
        Long tmp = threshold;
        if (null != tmp) return tmp;
        Class<ZipFolderAction> clazz = ZipFolderAction.class;
        synchronized (ZipFolderAction.class) {
            tmp = threshold;
            if (null != tmp) return tmp;
            long defaultThreshold = 0x40000000L;
            ConfigurationService service = Services.getConfigurationService();
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultThreshold;
            }
            String property = service.getProperty("com.openexchange.file.storage.zipFolderThreshold");
            threshold = tmp = null == property ? Long.valueOf(defaultThreshold) : Long.valueOf(property.trim());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        IDBasedFileAccess fileAccess = request.getFileAccess();
        IDBasedFolderAccess folderAccess = request.getFolderAccess();
        String folderId = request.getFolderId();
        if (Strings.isEmpty((String)folderId)) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{AbstractFileAction.Param.FOLDER_ID.getName()});
        }
        String tmp = request.getParameter("recursive");
        boolean recursive = AJAXRequestDataTools.parseBoolParameter((String)tmp);
        String folderName = folderAccess.getFolder(folderId).getName();
        folderName = ZipFolderAction.saneForFileName(folderName);
        AJAXRequestData ajaxRequestData = request.getRequestData();
        if (ajaxRequestData.setResponseHeader("Content-Type", "application/zip")) {
            this.createZipArchive(folderId, folderName, fileAccess, (IDBasedFolderAccess)(recursive ? folderAccess : null), ajaxRequestData);
            return new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct").setType(AJAXRequestResult.ResultType.DIRECT);
        }
        this.checkThreshold(folderId, fileAccess, folderAccess);
        ThresholdFileHolder fileHolder = new ThresholdFileHolder();
        fileHolder.setDisposition("attachment");
        fileHolder.setName(folderName + ".zip");
        fileHolder.setContentType("application/zip");
        fileHolder.setDelivery("download");
        this.createZipArchive(folderId, fileAccess, folderAccess, fileHolder.asOutputStream());
        ajaxRequestData.setFormat("file");
        return new AJAXRequestResult((Object)fileHolder, "file");
    }

    private void createZipArchive(String folderId, String saneFolderName, IDBasedFileAccess fileAccess, IDBasedFolderAccess folderAccess, AJAXRequestData ajaxRequestData) throws OXException {
        this.checkThreshold(folderId, fileAccess, folderAccess);
        StringBuilder sb = new StringBuilder(512);
        sb.append("attachment");
        DownloadUtility.appendFilenameParameter((String)(saneFolderName + ".zip"), (String)"application/zip", (String)ajaxRequestData.getUserAgent(), (StringBuilder)sb);
        ajaxRequestData.setResponseHeader("Content-Disposition", sb.toString());
        try {
            this.createZipArchive(folderId, fileAccess, folderAccess, ajaxRequestData.optOutputStream());
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private void checkThreshold(String folderId, IDBasedFileAccess fileAccess, IDBasedFolderAccess folderAccess) throws OXException {
        long threshold = ZipFolderAction.threshold();
        if (threshold > 0L) {
            this.examineFolder4Archive(folderId, fileAccess, folderAccess, 0L, threshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipArchive(String folderId, IDBasedFileAccess fileAccess, IDBasedFolderAccess folderAccess, OutputStream out) throws OXException {
        ZipArchiveOutputStream zipOutput = null;
        try {
            zipOutput = new ZipArchiveOutputStream(out);
            zipOutput.setEncoding("UTF-8");
            zipOutput.setUseLanguageEncodingFlag(true);
            zipOutput.setLevel(ZipFolderAction.getZipDocumentsCompressionLevel());
            int buflen = 65536;
            byte[] buf = new byte[buflen];
            this.addFolder2Archive(folderId, fileAccess, folderAccess, zipOutput, "", buflen, buf);
        }
        catch (Throwable throwable) {
            Streams.close(zipOutput);
            throw throwable;
        }
        Streams.close((Closeable)zipOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineFolder4Archive(String folderId, IDBasedFileAccess fileAccess, IDBasedFolderAccess folderAccess, long totalSize, long threshold) throws OXException {
        List<File.Field> columns = Arrays.asList(File.Field.ID, File.Field.FILE_SIZE);
        SearchIterator it = fileAccess.getDocuments(folderId, columns).results();
        try {
            long total = totalSize;
            while (it.hasNext()) {
                File file = (File)it.next();
                long fileSize = file.getFileSize();
                if (fileSize <= 0L || (total += fileSize) <= threshold) continue;
                throw FileStorageExceptionCodes.ARCHIVE_MAX_SIZE_EXCEEDED.create(new Object[]{UploadUtility.getSize((long)threshold, (int)2, (boolean)false, (boolean)true)});
            }
            SearchIterators.close((SearchIterator)it);
            it = null;
            if (null != folderAccess) {
                for (FileStorageFolder f : folderAccess.getSubfolders(folderId, false)) {
                    this.examineFolder4Archive(f.getId(), fileAccess, folderAccess, total, threshold);
                }
            }
        }
        finally {
            SearchIterators.close((SearchIterator)it);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFolder2Archive(String folderId, IDBasedFileAccess fileAccess, IDBasedFolderAccess idBasedFolderAccess, ZipArchiveOutputStream zipOutput, String pathPrefix, int buflen, byte[] buf) throws OXException {
        List<File.Field> columns = Arrays.asList(File.Field.ID, File.Field.FOLDER_ID, File.Field.FILENAME, File.Field.FILE_MIMETYPE);
        SearchIterator it = fileAccess.getDocuments(folderId, columns).results();
        try {
            while (it.hasNext()) {
                File file = (File)it.next();
                try {
                    this.addFile2Archive(file, fileAccess.getDocument(file.getId(), FileStorageFileAccess.CURRENT_VERSION), zipOutput, pathPrefix, buflen, buf);
                }
                catch (OXException e) {
                    if (FileStorageCodes.FILE_NOT_FOUND.equals(e)) continue;
                    throw e;
                }
            }
            SearchIterators.close((SearchIterator)it);
            it = null;
            if (null == idBasedFolderAccess) return;
            for (FileStorageFolder f : idBasedFolderAccess.getSubfolders(folderId, false)) {
                String path;
                String name = f.getName();
                int num = 1;
                while (true) {
                    try {
                        int pos = name.indexOf(46);
                        String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                        path = pathPrefix + entryName + "/";
                        ZipArchiveEntry entry = new ZipArchiveEntry(path);
                        zipOutput.putArchiveEntry((ArchiveEntry)entry);
                    }
                    catch (ZipException e) {
                        String message = e.getMessage();
                        if (message == null || !message.startsWith("duplicate entry")) {
                            throw e;
                        }
                        ++num;
                        continue;
                    }
                    break;
                }
                zipOutput.closeArchiveEntry();
                this.addFolder2Archive(f.getId(), fileAccess, idBasedFolderAccess, zipOutput, path, buflen, buf);
            }
            return;
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.HTTP_ERROR.create((Throwable)e, new Object[]{500, "Internal Server Error"});
        }
        finally {
            SearchIterators.close((SearchIterator)it);
        }
    }

    private void addFile2Archive(File file, InputStream in, ZipArchiveOutputStream zipOutput, String pathPrefix, int buflen, byte[] buf) throws OXException {
        try {
            int read;
            ZipArchiveEntry entry;
            String name = file.getFileName();
            if (null == name) {
                List extensions = MimeType2ExtMap.getFileExtensions((String)file.getFileMIMEType());
                name = extensions == null || extensions.isEmpty() ? "part.dat" : "part." + (String)extensions.get(0);
            }
            int num = 1;
            while (true) {
                try {
                    int pos = name.indexOf(46);
                    String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                    entry = new ZipArchiveEntry(pathPrefix + entryName);
                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                }
                catch (ZipException e) {
                    String message = e.getMessage();
                    if (message == null || !message.startsWith("duplicate entry")) {
                        throw e;
                    }
                    ++num;
                    continue;
                }
                break;
            }
            long size = 0L;
            while ((read = in.read(buf, 0, buflen)) > 0) {
                zipOutput.write(buf, 0, read);
                size += (long)read;
            }
            entry.setSize(size);
            zipOutput.closeArchiveEntry();
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.HTTP_ERROR.create((Throwable)e, new Object[]{500, "Internal Server Error"});
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    private static String saneForFileName(String fileName) {
        if (Strings.isEmpty((String)fileName)) {
            return "archive";
        }
        int len = fileName.length();
        StringBuilder sb = new StringBuilder(len);
        char prev = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = fileName.charAt(i);
            if (Strings.isWhitespace((char)c)) {
                if (prev == '_') continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('/' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('\\' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if (',' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('.' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            prev = '\u0000';
            sb.append(c);
        }
        String sanitized = sb.toString();
        return Strings.isEmpty((String)sanitized) ? "archive" : sanitized;
    }
}

