/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public class ZipDocumentsAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        List<IdVersionPair> idVersionPairs;
        String value = request.getParameter("body");
        if (Strings.isEmpty((String)value)) {
            idVersionPairs = request.getIdVersionPairs();
        } else {
            try {
                JSONArray jsonArray = new JSONArray(value);
                int len = jsonArray.length();
                idVersionPairs = new ArrayList<IdVersionPair>(len);
                for (int i = 0; i < len; ++i) {
                    JSONObject tuple = jsonArray.getJSONObject(i);
                    String id = tuple.getString(AbstractFileAction.Param.ID.getName());
                    String folderId = tuple.optString(AbstractFileAction.Param.FOLDER_ID.getName());
                    String version = tuple.optString(AbstractFileAction.Param.VERSION.getName(), FileStorageFileAccess.CURRENT_VERSION);
                    IdVersionPair pair = new IdVersionPair(id, version, folderId);
                    idVersionPairs.add(pair);
                }
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create((Throwable)e, new Object[]{"body", e.getMessage()});
            }
        }
        IDBasedFileAccess fileAccess = request.getFileAccess();
        AJAXRequestData ajaxRequestData = request.getRequestData();
        if (null != ajaxRequestData && ajaxRequestData.setResponseHeader("Content-Type", "application/zip")) {
            try {
                ajaxRequestData.setResponseHeader("Content-Disposition", "attachment; filename*=UTF-8''documents.zip; filename=\"documents.zip\"");
                this.createZipArchive(idVersionPairs, fileAccess, ajaxRequestData.optOutputStream());
                return new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct").setType(AJAXRequestResult.ResultType.DIRECT);
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        ThresholdFileHolder thresholdFileHolder = new ThresholdFileHolder();
        this.createZipArchive(idVersionPairs, fileAccess, thresholdFileHolder.asOutputStream());
        AJAXRequestData requestData = request.getRequestData();
        if (null != requestData) {
            requestData.setFormat("file");
        }
        thresholdFileHolder.setContentType("application/zip");
        thresholdFileHolder.setName("documents.zip");
        return new AJAXRequestResult((Object)thresholdFileHolder, "file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipArchive(List<IdVersionPair> idVersionPairs, IDBasedFileAccess fileAccess, OutputStream out) throws OXException {
        ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream(out);
        zipOutput.setEncoding("UTF-8");
        zipOutput.setUseLanguageEncodingFlag(true);
        zipOutput.setLevel(ZipDocumentsAction.getZipDocumentsCompressionLevel());
        try {
            int buflen = 8192;
            byte[] buf = new byte[8192];
            for (IdVersionPair idVersionPair : idVersionPairs) {
                String id = idVersionPair.getIdentifier();
                String version = idVersionPair.getVersion();
                if (null == version) {
                    version = FileStorageFileAccess.CURRENT_VERSION;
                }
                File fileMetadata = fileAccess.getFileMetadata(id, version);
                InputStream in = fileAccess.getDocument(id, version);
                try {
                    int read;
                    ZipArchiveEntry entry;
                    String name = fileMetadata.getFileName();
                    if (null == name) {
                        List extensions = MimeType2ExtMap.getFileExtensions((String)fileMetadata.getFileMIMEType());
                        name = extensions == null || extensions.isEmpty() ? "part.dat" : "part." + (String)extensions.get(0);
                    }
                    int num = 1;
                    while (true) {
                        try {
                            int pos = name.indexOf(46);
                            String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                            entry = new ZipArchiveEntry(entryName);
                            zipOutput.putArchiveEntry((ArchiveEntry)entry);
                        }
                        catch (ZipException e) {
                            String message = e.getMessage();
                            if (message == null || !message.startsWith("duplicate entry")) {
                                throw e;
                            }
                            ++num;
                            continue;
                        }
                        break;
                    }
                    long size = 0L;
                    while ((read = in.read(buf, 0, 8192)) > 0) {
                        zipOutput.write(buf, 0, read);
                        size += (long)read;
                    }
                    entry.setSize(size);
                    zipOutput.closeArchiveEntry();
                }
                catch (IOException e) {
                    throw FileStorageExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    Streams.close((Closeable)in);
                }
            }
        }
        finally {
            Streams.close((Closeable)zipOutput);
        }
    }
}

