/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.CreatedByComparator;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.FilteringSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;

@Action(method=RequestMethod.GET, name="versions", description="Get all versions", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the infoitem whose versions are requested."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for infoitems are defined in Common object data and Detailed infoitem data."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, responseDescription="Response with timestamp: An array with infoitem data. Each array element describes one infoitem and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter. The timestamp is the timestamp relating to the requested infostore item.")
public class VersionsAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        ArrayList<File.Field> columns = new ArrayList<File.Field>(request.getColumns());
        if (!columns.contains(File.Field.VERSION)) {
            columns.add(File.Field.VERSION);
        }
        File.Field sortingField = request.getSortingField();
        FileStorageFileAccess.SortDirection sortingOrder = request.getSortingOrder();
        TimedResult versions = fileAccess.getVersions(request.getId(), columns, sortingField, sortingOrder);
        if (File.Field.CREATED_BY.equals((Object)sortingField)) {
            ServerSession serverSession = request.getSession();
            CreatedByComparator comparator = new CreatedByComparator(serverSession.getUser().getLocale(), serverSession.getContext()).setDescending(FileStorageFileAccess.SortDirection.DESC.equals((Object)sortingOrder));
            final SearchIterator<File> iter = CreatedByComparator.resort((SearchIterator<File>)versions.results(), comparator);
            final TimedResult delegate = versions;
            versions = new TimedResult<File>(){

                public long sequenceNumber() throws OXException {
                    return delegate.sequenceNumber();
                }

                public SearchIterator<File> results() throws OXException {
                    return iter;
                }
            };
        }
        return this.result(this.skipVersion0((TimedResult<File>)versions), request);
    }

    private TimedResult<File> skipVersion0(final TimedResult<File> versions) throws OXException {
        return new TimedResult<File>(){

            public SearchIterator<File> results() throws OXException {
                return new FilteringSearchIterator<File>(versions.results()){

                    public boolean accept(File thing) throws OXException {
                        String version = thing.getVersion();
                        return version != null && !version.equals("0");
                    }
                };
            }

            public long sequenceNumber() throws OXException {
                return versions.sequenceNumber();
            }
        };
    }
}

