/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Actions;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedIgnorableVersionFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.tools.servlet.AjaxExceptionCodes;

@Actions(value={@Action(method=RequestMethod.PUT, name="update", description="Update an infoitem via PUT", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="timestamp", description="Timestamp of the updated infoitem. If the infoitem was modified after the specified timestamp, then the update must fail.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present."), @Action(method=RequestMethod.POST, name="update", description="Update an infoitem via POST", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="timestamp", description="Timestamp of the updated infoitem. If the infoitem was modified after the specified timestamp, then the update must fail."), @Parameter(name="json", description="Infoitem object as described in Common object data and Detailed infoitem data. The field id is not included."), @Parameter(name="file", description="File metadata as per <input type=\"file\" />")}, requestBody="Body of content-type \"multipart/form-data\" or \"multipart/mixed\" containing the above mentioned fields and file-data.", responseDescription="The response is sent as a HTML document (see introduction).")})
public class UpdateAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        FileID id;
        IDBasedIgnorableVersionFileAccess ignorableVersionFileAccess;
        boolean ignoreVersion;
        request.requireFileMetadata().require(AbstractFileAction.Param.TIMESTAMP);
        File file = request.getFile();
        if (file.getId() == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"id"});
        }
        IDBasedFileAccess fileAccess = request.getFileAccess();
        String fileId = file.getId();
        fileId = request.hasUploads() ? ((ignoreVersion = request.getBoolParameter("ignoreVersion")) && fileAccess instanceof IDBasedIgnorableVersionFileAccess ? ((ignorableVersionFileAccess = (IDBasedIgnorableVersionFileAccess)fileAccess).supportsIgnorableVersion((id = new FileID(fileId)).getService(), id.getAccountId()) ? ignorableVersionFileAccess.saveDocument(file, request.getUploadedFileData(), request.getTimestamp(), request.getSentColumns(), true) : fileAccess.saveDocument(file, request.getUploadedFileData(), request.getTimestamp(), request.getSentColumns())) : fileAccess.saveDocument(file, request.getUploadedFileData(), request.getTimestamp(), request.getSentColumns())) : fileAccess.saveFileMetadata(file, request.getTimestamp(), request.getSentColumns());
        return request.extendedResponse() ? this.result(fileAccess.getFileMetadata(null == fileId ? file.getId() : fileId, FileStorageFileAccess.CURRENT_VERSION), request) : this.success(file.getSequenceNumber());
    }
}

