/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Actions;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.java.Strings;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.Date;

@Actions(value={@Action(method=RequestMethod.PUT, name="new", description="Create an infoitem via PUT", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. The field id is not included.", responseDescription="Object ID of the newly created infoitem."), @Action(method=RequestMethod.POST, name="new", description="Create an infoitem via POST", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="json", description="Infoitem object as described in Common object data and Detailed infoitem data. The field id is not included."), @Parameter(name="file", description="File metadata as per <input type=\"file\" />")}, requestBody="Body of content-type \"multipart/form-data\" or \"multipart/mixed\" containing the above mentioned fields and file-data.", responseDescription="Object ID of the newly created infoitem. The response is sent as a HTML document (see introduction).")})
public class NewAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.requireFileMetadata();
        IDBasedFileAccess fileAccess = request.getFileAccess();
        File file = request.getFile();
        if (Strings.isEmpty((String)file.getFolderId())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"folder"});
        }
        file.setId(FileStorageFileAccess.NEW);
        if (request.hasUploads()) {
            fileAccess.saveDocument(file, request.getUploadedFileData(), -1L);
        } else {
            fileAccess.saveFileMetadata(file, -1L);
        }
        if (request.extendedResponse()) {
            return this.result(fileAccess.getFileMetadata(file.getId(), FileStorageFileAccess.CURRENT_VERSION), request);
        }
        return new AJAXRequestResult((Object)file.getId(), new Date(file.getSequenceNumber()));
    }
}

