/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.LastModifiedAwareAJAXActionService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.Document;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.session.Session;
import com.openexchange.tools.images.ImageTransformationUtility;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, defaultFormat="file", name="[filename]?action=document", description="Get an infoitem document", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested infoitem."), @Parameter(name="folder", description="Object ID of the infoitem's folder."), @Parameter(name="version", optional=true, description="If present the infoitem data describes the given version. Otherwise the current version is returned"), @Parameter(name="content_type", optional=true, description="If present the response declares the given content_type in the Content-Type header.")}, responseDescription="The raw byte data of the document. The response type for the HTTP Request is set accordingly to the defined mimetype for this infoitem or the content_type given.")
@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public class DocumentAction
extends AbstractFileAction
implements ETagAwareAJAXActionService,
LastModifiedAwareAJAXActionService {
    static final Logger LOGGER = LoggerFactory.getLogger(DocumentAction.class);
    public static final String DOCUMENT = "com.openexchange.file.storage.json.DocumentAction.DOCUMENT";

    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        Document document;
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        final String id = request.getId();
        final String version = request.getVersion();
        Document document2 = document = request.getCachedDocument() == null ? fileAccess.getDocumentAndMetadata(id, version) : request.getCachedDocument();
        if (document != null) {
            long lastModified;
            FileHolder fileHolder = new FileHolder(new IFileHolder.InputStreamClosure(){

                public InputStream newStream() throws OXException, IOException {
                    return document.getData();
                }
            }, document.getSize(), document.getMimeType(), document.getName());
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            String etag = document.getEtag();
            if (null != etag) {
                result.setHeader("ETag", etag);
            }
            if ((lastModified = document.getLastModified()) > 0L) {
                result.setHeader("Last-Modified", Tools.formatHeaderDate((Date)new Date(lastModified)));
            }
            return result;
        }
        File fileMetadata = fileAccess.getFileMetadata(id, version);
        final ServerSession session = request.getSession();
        Object isClosure = ImageTransformationUtility.seemsLikeThumbnailRequest((AJAXRequestData)request.getRequestData()) ? new IFileHolder.InputStreamClosure(){

            public InputStream newStream() throws OXException, IOException {
                InputStream inputStream;
                IDBasedFileAccess fileAccess = Services.getFileAccessFactory().createAccess((Session)session);
                try {
                    inputStream = fileAccess.optThumbnailStream(id, version);
                }
                catch (OXException e) {
                    LOGGER.debug("Unable to retrieve thumbnail for file: {}", (Object)id, (Object)e);
                    inputStream = null;
                }
                if (null == inputStream) {
                    inputStream = fileAccess.getDocument(id, version);
                }
                if (inputStream instanceof BufferedInputStream || inputStream instanceof ByteArrayInputStream) {
                    return inputStream;
                }
                return new BufferedInputStream(inputStream, 65536);
            }
        } : new IFileHolder.InputStreamClosure(){

            public InputStream newStream() throws OXException, IOException {
                IDBasedFileAccess fileAccess = Services.getFileAccessFactory().createAccess((Session)session);
                InputStream inputStream = fileAccess.getDocument(id, version);
                if (inputStream instanceof BufferedInputStream || inputStream instanceof ByteArrayInputStream) {
                    return inputStream;
                }
                return new BufferedInputStream(inputStream, 65536);
            }
        };
        FileHolder fileHolder = new FileHolder(isClosure, fileMetadata.getFileSize(), fileMetadata.getFileMIMEType(), fileMetadata.getFileName());
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        this.createAndSetETag(fileMetadata, request, result);
        Date lastModified = fileMetadata.getLastModified();
        if (null != lastModified) {
            result.setHeader("Last-Modified", Tools.formatHeaderDate((Date)lastModified));
        }
        return result;
    }

    private void createAndSetETag(File fileMetadata, InfostoreRequest request, AJAXRequestResult result) throws OXException {
        this.setETag(FileStorageUtility.getETagFor((File)fileMetadata), 0L, result);
    }

    public boolean checkETag(String clientETag, AJAXRequestData requestData, ServerSession session) throws OXException {
        String version;
        String id;
        AJAXInfostoreRequest request = new AJAXInfostoreRequest(requestData, session);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        Document document = fileAccess.getDocumentAndMetadata(id = request.getId(), version = request.getVersion(), clientETag);
        if (document != null) {
            requestData.setProperty(DOCUMENT, (Object)document);
            String etag = document.getEtag();
            return etag != null && etag.equals(clientETag);
        }
        File fileMetadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
        return FileStorageUtility.getETagFor((File)fileMetadata).equals(clientETag);
    }

    public boolean checkLastModified(long clientLastModified, AJAXRequestData requestData, ServerSession session) throws OXException {
        String version;
        String id;
        AJAXInfostoreRequest request = new AJAXInfostoreRequest(requestData, session);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        Document document = fileAccess.getDocumentAndMetadata(id = request.getId(), version = request.getVersion());
        if (document != null) {
            requestData.setProperty(DOCUMENT, (Object)document);
            long lastModified = document.getLastModified();
            return lastModified > 0L ? false : clientLastModified > lastModified;
        }
        File fileMetadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
        Date lastModified = fileMetadata.getLastModified();
        return null == lastModified ? false : clientLastModified > lastModified.getTime();
    }

    public void setETag(String eTag, long expires, AJAXRequestResult result) throws OXException {
        result.setExpires(expires);
        if (eTag != null) {
            result.setHeader("ETag", eTag);
        }
    }
}

