/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Actions;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import java.util.Date;

@Actions(value={@Action(method=RequestMethod.PUT, name="copy", description="Copy an infoitem via PUT", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="folder", description="The Folder of the Object."), @Parameter(name="timestamp", description="Timestamp of the infostore object.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present.", responseDescription="The id of the newly created object."), @Action(method=RequestMethod.POST, name="copy", description="Copy an infoitem via POST", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="timestamp", description="Timestamp of the updated infoitem. If the infoitem was modified after the specified timestamp, then the update must fail."), @Parameter(name="json", description="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present."), @Parameter(name="file", description="File metadata as per <input type=\"file\" />")}, requestBody="Body of content-type \"multipart/form-data\" or \"multipart/mixed\" containing the above mentioned fields and file-data.", responseDescription="The response is sent as a HTML document (see introduction).")})
public class CopyAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.ID).requireFileMetadata();
        IDBasedFileAccess fileAccess = request.getFileAccess();
        String id = request.getId();
        File file = request.getFile();
        String folder = file.getFolderId();
        String version = request.getVersion();
        String newId = null;
        newId = request.hasUploads() ? fileAccess.copy(id, version, folder, file, request.getUploadedFileData(), request.getSentColumns()) : fileAccess.copy(id, version, folder, file, null, request.getSentColumns());
        return new AJAXRequestResult((Object)newId, new Date(file.getSequenceNumber()));
    }
}

