/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.FileMetadataWriter;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileAction
implements AJAXActionService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileAction.class);
    private static final FileMetadataWriter fileWriter = new FileMetadataWriter();

    protected FileMetadataWriter getWriter() {
        return fileWriter;
    }

    public abstract AJAXRequestResult handle(InfostoreRequest var1) throws OXException;

    public AJAXRequestResult result(TimedResult<File> documents, InfostoreRequest request) throws OXException {
        SearchIterator results = documents.results();
        return this.results((SearchIterator<File>)results, documents.sequenceNumber(), request);
    }

    protected AJAXRequestResult results(SearchIterator<File> results, long timestamp, InfostoreRequest request) throws OXException {
        return new AJAXRequestResult(results, new Date(timestamp), "infostore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult result(Delta<File> delta, InfostoreRequest request) throws OXException {
        SearchIterator results = delta.results();
        JSONArray array = null;
        try {
            array = this.getWriter().write((SearchIterator<File>)results, request.getColumns(), request.getTimezone());
        }
        finally {
            results.close();
        }
        SearchIterator deleted = delta.getDeleted();
        try {
            while (deleted.hasNext()) {
                array.put((Object)((File)deleted.next()).getId());
            }
        }
        finally {
            deleted.close();
        }
        return new AJAXRequestResult((Object)array, new Date(delta.sequenceNumber()));
    }

    public AJAXRequestResult result(File file, InfostoreRequest request) throws OXException {
        return new AJAXRequestResult((Object)file, new Date(file.getSequenceNumber()), "infostore");
    }

    public AJAXRequestResult result(List<String> ids, InfostoreRequest request) throws OXException {
        JSONArray array = new JSONArray();
        try {
            for (String id : ids) {
                JSONObject object = new JSONObject();
                object.put("id", (Object)id);
                object.put("folder", (Object)request.getFolderForID(id));
                array.put((Object)object);
            }
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
        return new AJAXRequestResult((Object)array);
    }

    public AJAXRequestResult result(String[] versions, long sequenceNumber, InfostoreRequest request) throws OXException {
        JSONArray array = new JSONArray();
        for (String i : versions) {
            array.put((Object)i);
        }
        return new AJAXRequestResult((Object)array, new Date(sequenceNumber));
    }

    public AJAXRequestResult success(long sequenceNumber) {
        return new AJAXRequestResult((Object)Boolean.TRUE, new Date(sequenceNumber));
    }

    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        AJAXInfostoreRequest req = new AJAXInfostoreRequest(requestData, session);
        try {
            this.before(req);
            AJAXRequestResult result = this.handle(req);
            this.success(req, result);
            AJAXRequestResult aJAXRequestResult = result;
            return aJAXRequestResult;
        }
        catch (OXException x) {
            this.failure(req, x);
            throw x;
        }
        catch (NullPointerException e) {
            this.failure(req, e);
            LOG.error("", (Throwable)e);
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{"Null dereference."});
        }
        catch (RuntimeException e) {
            this.failure(req, e);
            LOG.error("", (Throwable)e);
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            this.after(req);
            requestData.cleanUploads();
        }
    }

    protected void after(AJAXInfostoreRequest req) {
        IDBasedFolderAccess folderAccess;
        IDBasedFileAccess fileAccess = req.optFileAccess();
        if (null != fileAccess) {
            try {
                fileAccess.finish();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null != (folderAccess = req.optFolderAccess())) {
            try {
                folderAccess.finish();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void failure(AJAXInfostoreRequest req, Throwable throwable) throws OXException {
    }

    protected void success(AJAXInfostoreRequest req, AJAXRequestResult result) throws OXException {
    }

    protected void before(AJAXInfostoreRequest req) throws OXException {
    }

    protected static int getZipDocumentsCompressionLevel() throws OXException {
        ConfigurationService configService = Services.getConfigurationService();
        if (null == configService) {
            return -1;
        }
        int level = configService.getIntProperty("com.openexchange.infostore.zipDocumentsCompressionLevel", -1);
        if (level < -1 || level > 9) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(new Object[]{"com.openexchange.infostore.zipDocumentsCompressionLevel"});
        }
        return level;
    }

    public static enum Param {
        ID("id"),
        FOLDER_ID("folder"),
        VERSION("version"),
        COLUMNS("columns"),
        SORT("sort"),
        ORDER("order"),
        TIMEZONE("timezone"),
        TIMESTAMP("timestamp"),
        IGNORE("ignore"),
        DIFF("diff"),
        ATTACHED_ID("attached"),
        MODULE("module"),
        ATTACHMENT("attachment");

        String name;

        private Param(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

