/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.Document;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.FileMetadataParser;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.infostore.utils.InfostoreConfigUtils;
import com.openexchange.groupware.infostore.utils.UploadSizeValidation;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.java.FileKnowingInputStream;
import com.openexchange.java.Strings;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AJAXInfostoreRequest
implements InfostoreRequest {
    private static final String JSON = "json";
    private static final FileMetadataParser parser = FileMetadataParser.getInstance();
    private List<File.Field> columns;
    private byte[] contentData;
    private List<File.Field> fields;
    private File file;
    private IDBasedFileAccess fileAccess;
    private IDBasedFolderAccess folderAccess;
    private Map<String, String> folderMapping;
    private Map<String, Set<String>> versionMapping;
    private List<String> folders;
    private List<String> idVersions;
    private List<String> ids;
    private final ServerSession session;
    private File.Field sortingField;
    private String[] versions;
    protected AJAXRequestData data;

    public AJAXInfostoreRequest(AJAXRequestData requestData, ServerSession session) {
        this.data = requestData;
        this.session = session;
    }

    @Override
    public AJAXRequestData getRequestData() {
        return this.data;
    }

    @Override
    public boolean extendedResponse() throws OXException {
        return this.data.isSet("extendedResponse") && (Boolean)this.data.getParameter("extendedResponse", Boolean.class) != false;
    }

    @Override
    public int getAttachedId() {
        return this.getInt(AbstractFileAction.Param.ATTACHED_ID);
    }

    @Override
    public int getAttachment() {
        return this.getInt(AbstractFileAction.Param.ATTACHMENT);
    }

    @Override
    public AttachmentBase getAttachmentBase() {
        return Services.getAttachmentBase();
    }

    @Override
    public boolean getBoolParameter(String name) {
        return AJAXRequestDataTools.parseBoolParameter((String)name, (AJAXRequestData)this.data);
    }

    @Override
    public List<File.Field> getColumns() throws OXException {
        if (this.columns != null) {
            return this.columns;
        }
        String parameter = this.data.getParameter(AbstractFileAction.Param.COLUMNS.getName());
        if (parameter == null || parameter.length() == 0) {
            this.columns = Arrays.asList(File.Field.values());
            return this.columns;
        }
        String[] columnStrings = Strings.splitByComma((String)parameter);
        ArrayList<File.Field> fields = new ArrayList<File.Field>(columnStrings.length);
        ArrayList<String> unknownColumns = new ArrayList<String>(columnStrings.length);
        for (String columnNumberOrName : columnStrings) {
            File.Field field = File.Field.get((String)columnNumberOrName);
            if (field == null) {
                unknownColumns.add(columnNumberOrName);
                continue;
            }
            fields.add(field);
        }
        if (!unknownColumns.isEmpty()) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{AbstractFileAction.Param.COLUMNS.getName(), ((Object)unknownColumns).toString()});
        }
        this.columns = fields;
        return this.columns;
    }

    @Override
    public long getDiff() {
        String parameter = this.data.getParameter(AbstractFileAction.Param.DIFF.getName());
        if (parameter == null) {
            return -1L;
        }
        return Long.parseLong(parameter);
    }

    @Override
    public int getEnd() {
        String parameter = this.data.getParameter("end");
        if (parameter == null) {
            parameter = this.data.getParameter("limit");
            if (parameter == null) {
                return -11;
            }
            return Integer.parseInt(parameter) - 1;
        }
        return Integer.parseInt(parameter);
    }

    @Override
    public File getFile() throws OXException {
        this.parseFile();
        return this.file;
    }

    @Override
    public IDBasedFileAccess getFileAccess() {
        if (this.fileAccess != null) {
            return this.fileAccess;
        }
        this.fileAccess = Services.getFileAccessFactory().createAccess((Session)this.session);
        return this.fileAccess;
    }

    @Override
    public IDBasedFileAccess optFileAccess() {
        return this.fileAccess;
    }

    @Override
    public IDBasedFolderAccess getFolderAccess() throws OXException {
        if (this.folderAccess != null) {
            return this.folderAccess;
        }
        this.folderAccess = Services.getFolderAccessFactory().createAccess((Session)this.session);
        return this.folderAccess;
    }

    @Override
    public IDBasedFolderAccess optFolderAccess() {
        return this.folderAccess;
    }

    @Override
    public String getFolderAt(int index) {
        return index < 0 || index >= this.folders.size() ? null : this.folders.get(index);
    }

    @Override
    public String getFolderForID(String id) throws OXException {
        this.parseIDList();
        return this.folderMapping.get(id);
    }

    @Override
    public String getFolderId() throws OXException {
        String parameter = this.data.getParameter(AbstractFileAction.Param.FOLDER_ID.getName());
        if (parameter == null || parameter.equals("null") || parameter.equals("undefined")) {
            return FileStorageFileAccess.ALL_FOLDERS;
        }
        return parameter;
    }

    @Override
    public List<String> getFolders() {
        return this.folders;
    }

    @Override
    public String getId() {
        return this.data.getParameter(AbstractFileAction.Param.ID.getName());
    }

    @Override
    public List<String> getIds() throws OXException {
        this.parseIDList();
        return this.ids;
    }

    @Override
    public List<IdVersionPair> getIdVersionPairs() throws OXException {
        this.parseIDList();
        ArrayList<IdVersionPair> retval = new ArrayList<IdVersionPair>(this.ids.size());
        for (String id : this.ids) {
            Set<String> versions = this.versionMapping.get(id);
            if (null == versions) {
                retval.add(new IdVersionPair(id, FileStorageFileAccess.CURRENT_VERSION, this.folderMapping.get(id)));
                continue;
            }
            for (String version : versions) {
                retval.add(new IdVersionPair(id, version, this.folderMapping.get(id)));
            }
        }
        return retval;
    }

    @Override
    public Set<String> getIgnore() {
        String parameter = this.data.getParameter(AbstractFileAction.Param.IGNORE.getName());
        if (parameter == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(Strings.splitByComma((String)parameter)));
    }

    @Override
    public int getModule() {
        return this.getInt(AbstractFileAction.Param.MODULE);
    }

    @Override
    public String getParameter(String name) {
        return this.data.getParameter(name);
    }

    @Override
    public String getSearchFolderId() throws OXException {
        return this.getFolderId();
    }

    @Override
    public String getSearchQuery() throws OXException {
        Object data2 = this.data.getData();
        if (data2 == null) {
            return "";
        }
        JSONObject queryObject = (JSONObject)data2;
        try {
            return queryObject.getString("pattern");
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
    }

    @Override
    public List<File.Field> getSentColumns() throws OXException {
        this.parseFile();
        return this.fields;
    }

    @Override
    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public File.Field getSortingField() throws OXException {
        if (this.sortingField != null) {
            return this.sortingField;
        }
        String sort = this.data.getParameter(AbstractFileAction.Param.SORT.getName());
        if (sort == null) {
            return null;
        }
        this.sortingField = File.Field.get((String)sort);
        File.Field field = this.sortingField;
        if (field == null) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{AbstractFileAction.Param.SORT.getName(), sort});
        }
        return field;
    }

    @Override
    public FileStorageFileAccess.SortDirection getSortingOrder() throws OXException {
        FileStorageFileAccess.SortDirection sortDirection = FileStorageFileAccess.SortDirection.get((String)this.data.getParameter(AbstractFileAction.Param.ORDER.getName()));
        if (sortDirection == null) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{AbstractFileAction.Param.ORDER.getName(), sortDirection});
        }
        return sortDirection;
    }

    @Override
    public int getStart() {
        String parameter = this.data.getParameter("start");
        if (parameter == null) {
            if (this.data.getParameter("limit") != null) {
                return 0;
            }
            return -11;
        }
        return Integer.valueOf(parameter);
    }

    @Override
    public long getTimestamp() {
        String parameter = this.data.getParameter(AbstractFileAction.Param.TIMESTAMP.getName());
        if (parameter == null) {
            return -1L;
        }
        return Long.parseLong(parameter);
    }

    @Override
    public TimeZone getTimezone() throws OXException {
        String parameter = this.data.getParameter(AbstractFileAction.Param.TIMEZONE.getName());
        if (parameter == null) {
            parameter = this.getSession().getUser().getTimeZone();
        }
        return TimeZone.getTimeZone(parameter);
    }

    @Override
    public InputStream getUploadedFileData() throws OXException {
        long maxSize = InfostoreConfigUtils.determineRelevantUploadSize();
        if (this.data.hasUploads(-1L, maxSize > 0L ? maxSize : -1L)) {
            try {
                UploadFile uploadFile = (UploadFile)this.data.getFiles(-1L, maxSize > 0L ? maxSize : -1L).get(0);
                UploadSizeValidation.checkSize((long)uploadFile.getSize());
                java.io.File tmpFile = uploadFile.getTmpFile();
                return new FileKnowingInputStream((InputStream)new FileInputStream(tmpFile), tmpFile);
            }
            catch (FileNotFoundException e) {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        if (this.contentData != null) {
            return new UnsynchronizedByteArrayInputStream(this.contentData);
        }
        return null;
    }

    @Override
    public InputStream getUploadStream() throws OXException {
        try {
            return this.data.getUploadStream();
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public String getVersion() {
        String parameter = this.data.getParameter(AbstractFileAction.Param.VERSION.getName());
        if (parameter == null) {
            return FileStorageFileAccess.CURRENT_VERSION;
        }
        return "null".equalsIgnoreCase(parameter) ? FileStorageFileAccess.CURRENT_VERSION : parameter;
    }

    @Override
    public String[] getVersions() throws OXException {
        if (this.versions != null) {
            return this.versions;
        }
        JSONArray body = (JSONArray)this.data.requireData();
        try {
            this.versions = new String[body.length()];
            for (int i = 0; i < this.versions.length; ++i) {
                this.versions[i] = body.getString(i);
            }
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
        return this.versions;
    }

    public boolean has(String paramName) {
        return this.data.getParameter(paramName) != null;
    }

    @Override
    public boolean hasUploads() throws OXException {
        long maxSize = InfostoreConfigUtils.determineRelevantUploadSize();
        return this.data.hasUploads(-1L, maxSize > 0L ? maxSize : -1L) || this.contentData != null;
    }

    @Override
    public boolean isForSpecificVersion() {
        return this.getVersion() != FileStorageFileAccess.CURRENT_VERSION;
    }

    @Override
    public InfostoreRequest require(AbstractFileAction.Param ... params) throws OXException {
        String[] names = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            names[i] = params[i].getName();
        }
        List missingParameters = this.data.getMissingParameters(names);
        if (!missingParameters.isEmpty()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{missingParameters.toString()});
        }
        return this;
    }

    @Override
    public InfostoreRequest requireBody() throws OXException {
        long maxSize;
        if (this.data.getData() == null && !this.data.hasUploads(-1L, (maxSize = InfostoreConfigUtils.determineRelevantUploadSize()) > 0L ? maxSize : -1L) && this.data.getParameter(JSON) == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"data"});
        }
        return this;
    }

    @Override
    public InfostoreRequest requireFileMetadata() throws OXException {
        return this.requireBody();
    }

    private int getInt(AbstractFileAction.Param param) {
        return Integer.parseInt(this.data.getParameter(param.getName()));
    }

    private void parseIDList() throws OXException {
        try {
            if (this.ids != null) {
                return;
            }
            JSONArray array = (JSONArray)this.data.requireData();
            int length = array.length();
            ArrayList<String> ids = new ArrayList<String>(length);
            this.ids = ids;
            ArrayList<String> folders = new ArrayList<String>(length);
            this.folders = folders;
            ArrayList<String> idVersions = new ArrayList<String>(length);
            this.idVersions = idVersions;
            HashMap<String, String> folderMapping = new HashMap<String, String>(length);
            this.folderMapping = folderMapping;
            HashMap<String, Set<String>> versionMapping = new HashMap<String, Set<String>>(length);
            this.versionMapping = versionMapping;
            int size = length;
            for (int i = 0; i < size; ++i) {
                JSONObject tuple = array.getJSONObject(i);
                String id = tuple.getString(AbstractFileAction.Param.ID.getName());
                ids.add(id);
                String folderId = tuple.optString(AbstractFileAction.Param.FOLDER_ID.getName());
                folders.add(folderId);
                folderMapping.put(id, folderId);
                String version = tuple.optString(AbstractFileAction.Param.VERSION.getName(), FileStorageFileAccess.CURRENT_VERSION);
                idVersions.add(version);
                LinkedHashSet<String> list = (LinkedHashSet<String>)versionMapping.get(id);
                if (null == list) {
                    list = new LinkedHashSet<String>(2);
                    versionMapping.put(id, list);
                }
                list.add(version);
            }
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
    }

    protected void parseFile() throws OXException {
        String fileDisplay;
        List list;
        if (this.file != null) {
            return;
        }
        this.requireFileMetadata();
        JSONObject object = (JSONObject)this.data.getData();
        if (object == null) {
            try {
                object = new JSONObject(this.data.getParameter(JSON));
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{e.getMessage()});
            }
        }
        UploadFile uploadFile = null;
        long maxSize = InfostoreConfigUtils.determineRelevantUploadSize();
        if (this.data.hasUploads(-1L, maxSize > 0L ? maxSize : -1L)) {
            uploadFile = (UploadFile)this.data.getFiles(-1L, maxSize > 0L ? maxSize : -1L).get(0);
        }
        if (this.data.getUploadEvent() != null && (list = this.data.getUploadEvent().getUploadFilesByFieldName("file")) != null && !list.isEmpty()) {
            uploadFile = (UploadFile)list.get(0);
        }
        this.file = parser.parse(object);
        this.fields = parser.getFields(object);
        if (uploadFile != null) {
            if (!this.fields.contains(File.Field.FILENAME) || this.file.getFileName() == null || this.file.getFileName().trim().length() == 0) {
                this.file.setFileName(uploadFile.getPreparedFileName());
                this.fields.add(File.Field.FILENAME);
            }
            if (!this.fields.contains(File.Field.FILE_MIMETYPE)) {
                this.file.setFileMIMEType(uploadFile.getContentType());
                this.fields.add(File.Field.FILE_MIMETYPE);
            }
            this.file.setFileSize(uploadFile.getSize());
            this.fields.add(File.Field.FILE_SIZE);
        }
        if ((fileDisplay = this.data.getParameter("filedisplay")) != null && fileDisplay.trim().length() > 0 && (this.file.getFileName() == null || this.file.getFileName().trim().length() == 0)) {
            this.file.setFileName(fileDisplay);
            this.fields.add(File.Field.FILENAME);
        }
        if (this.has("id") && !this.fields.contains(File.Field.ID)) {
            this.file.setId(this.getId());
            this.fields.add(File.Field.ID);
        }
        if (object.has("content")) {
            try {
                this.contentData = object.opt("content").toString().getBytes("UTF-8");
                this.file.setFileSize((long)this.contentData.length);
                this.fields.add(File.Field.FILE_SIZE);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    @Override
    public Document getCachedDocument() {
        return (Document)this.data.getProperty("com.openexchange.file.storage.json.DocumentAction.DOCUMENT");
    }
}

