/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.i18n.I18nService;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class I18nServices {
    private static final Logger LOG = LoggerFactory.getLogger(I18nServices.class);
    private static final I18nServices SINGLETON = new I18nServices();
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>();
    private static final Locale DEFAULT_LOCALE = Locale.US;

    public static I18nServices getInstance() {
        return SINGLETON;
    }

    private I18nServices() {
    }

    public void addService(I18nService service) {
        if (null != this.services.put(service.getLocale(), service)) {
            LOG.warn("Another i18n translation service discovered for {}", (Object)service.getLocale());
        }
    }

    public void removeService(I18nService service) {
        if (null == this.services.remove(service.getLocale())) {
            LOG.warn("Unknown i18n translation service shut down for {}", (Object)service.getLocale());
        }
    }

    public I18nService getService(Locale locale) {
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        I18nService retval = this.services.get(loc);
        if (null == retval && !"en".equalsIgnoreCase(loc.getLanguage())) {
            LOG.warn("No i18n service for locale {}.", (Object)loc);
        }
        return retval;
    }
}

