/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AbstractFileFieldHandler;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldHandler;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.meta.FileFieldGet;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetadataWriter {
    protected static final Logger LOG = LoggerFactory.getLogger(FileMetadataWriter.class);
    protected static final JSONHandler JSON = new JSONHandler();

    public JSONArray write(SearchIterator<File> files, List<File.Field> columns, TimeZone timeZone) throws OXException {
        JSONArray array = new JSONArray(32);
        while (files.hasNext()) {
            array.put((Object)this.writeArray((File)files.next(), columns, timeZone));
        }
        files.close();
        return array;
    }

    public JSONArray writeArray(File f, List<File.Field> columns, TimeZone tz) {
        JSONArray array = new JSONArray(columns.size());
        for (File.Field field : columns) {
            array.put(this.writeAttribute(f, field, tz));
        }
        return array;
    }

    private Object writeAttribute(File f, File.Field field, TimeZone tz) {
        return field.handle((FileFieldHandler)JSON, new Object[]{f, tz});
    }

    public JSONObject write(final File file, final TimeZone timezone) {
        return (JSONObject)File.Field.inject((FileFieldHandler)new AbstractFileFieldHandler(){

            public Object handle(File.Field field, Object ... args) {
                JSONObject o = (JSONObject)this.get(0, JSONObject.class, args);
                try {
                    o.put(field.getName(), JSON.handle(field, file, timezone));
                }
                catch (JSONException e) {
                    LOG.error("Error writing field: {}", (Object)field.getName(), (Object)e);
                }
                return o;
            }
        }, (Object)new JSONObject(), (Object[])new Object[0]);
    }

    private static class JSONHandler
    extends AbstractFileFieldHandler {
        private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
        private final FileFieldGet get = new FileFieldGet();

        protected JSONHandler() {
        }

        public Object handle(File.Field field, Object ... args) {
            Object value = field.doSwitch((FileFieldSwitcher)this.get, args);
            if (File.Field.FILE_MIMETYPE == field) {
                if (null == value) {
                    return value;
                }
                String ct = value.toString();
                if (ct.indexOf(59) <= 0) {
                    return value;
                }
                try {
                    return ContentType.getBaseType((String)ct);
                }
                catch (OXException e) {
                    return value;
                }
            }
            if (value == null && field == File.Field.LOCKED_UNTIL) {
                return 0;
            }
            if (Date.class.isInstance(value)) {
                Date d = (Date)value;
                TimeZone tz = (TimeZone)this.get(1, TimeZone.class, args);
                if (field == File.Field.LAST_MODIFIED_UTC) {
                    tz = UTC;
                }
                if (field == File.Field.LOCKED_UNTIL && (d == null || d.getTime() <= System.currentTimeMillis())) {
                    return 0;
                }
                return this.writeDate((Date)value, tz);
            }
            switch (field) {
                case CATEGORIES: {
                    return this.handleCategories((String)value);
                }
                case META: {
                    try {
                        if (value == null) {
                            return null;
                        }
                        return JSONCoercion.coerceToJSON((Object)value);
                    }
                    catch (JSONException e) {
                        LOG.error("", (Throwable)e);
                        return null;
                    }
                }
            }
            return value;
        }

        private Object writeDate(Date date, TimeZone tz) {
            int offset = tz == null ? 0 : tz.getOffset(date.getTime());
            long time = date.getTime() + (long)offset;
            if (time < 0L) {
                time = Long.MAX_VALUE;
            }
            return time;
        }

        private JSONArray handleCategories(String value) {
            if (value == null) {
                return null;
            }
            String[] strings = Strings.splitByComma((String)value);
            JSONArray array = new JSONArray();
            for (String string : strings) {
                array.put((Object)string);
            }
            return array;
        }
    }
}

